#[test]
fn test() {
	#[derive(Debug,PartialEq,serde_derive::Deserialize)]
	struct Test {
		signed: i32,
		unsigned: u32,

		neg: i32,

		binary_k: u32,
		binary_t: u64,

		si_m: u32,
		si_e: u64,
	}

	let s = b"
		signed: -8 # inline
		unsigned: 16

		neg: -190

		binary_k: 2Ki
		binary_t: 16Ti

		si_m: 10M
		si_e: 17E
	";

	let mut d = crate::Deserializer::from(buffered_reader::Memory::new(s));
	let t = <Test as serde::de::Deserialize>::deserialize(&mut d).unwrap();
	assert_eq!(t, Test{
		signed: -8,
		unsigned: 16,

		neg: -190,

		binary_k: 2 * 2u32.pow(10),
		binary_t: 16 * 2u64.pow(40),

		si_m: 10_000_000,
		si_e: 17_000_000_000_000_000_000,
	})
}
