#[non_exhaustive]
#[derive(Debug)]
pub enum DeserializeError {
	Custom(String),
	Invalid(String),
	Io(std::io::Error),
	ParseInt(std::num::ParseIntError),
	Unimplemented(&'static str),
	Utf8(std::str::Utf8Error),
}

impl std::fmt::Display for DeserializeError {
	fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
		write!(f, "{:?}", self)
	}
}

impl std::error::Error for DeserializeError {
}

impl From<std::io::Error> for DeserializeError {
	fn from(that: std::io::Error) -> Self {
		Self::Io(that)
	}
}

impl From<std::num::ParseIntError> for DeserializeError {
	fn from(that: std::num::ParseIntError) -> Self {
		Self::ParseInt(that)
	}
}

impl From<std::str::Utf8Error> for DeserializeError {
	fn from(that: std::str::Utf8Error) -> Self {
		Self::Utf8(that)
	}
}

impl serde::de::Error for DeserializeError {
	fn custom<T: std::fmt::Display>(msg: T) -> Self {
		Self::Custom(format!("{}", msg))
	}
}
