#[test]
fn test() {
	#[derive(Debug,PartialEq,serde_derive::Deserialize)]
	struct Test {
		signed: i32,
		unsigned: u32,
	}

	let s = b"
		signed: -8 # inline
		unsigned: 16
	";

	let mut d = crate::Deserializer::from(buffered_reader::Memory::new(s));
	let t = <Test as serde::de::Deserialize>::deserialize(&mut d).unwrap();
	assert_eq!(t, Test{signed: -8, unsigned: 16})
}
