#[test]
fn test_strings() {
	#[derive(Debug,PartialEq,serde_derive::Deserialize)]
	struct Test {
		a: String,
		bar: String,
	}

	let s = b"a: foobar\nbar: bazbaz\n";

	let mut d = crate::Deserializer::from(buffered_reader::Memory::new(s));
	let t = <Test as serde::de::Deserialize>::deserialize(&mut d).unwrap();
	assert_eq!(t, Test{a: "foobar".into(), bar: "bazbaz".into()})
}

#[test]
fn test_multiline_strings() {
	#[derive(Debug,PartialEq,serde_derive::Deserialize)]
	struct Test {
		tabs: String,
		spaces: String,
	}

	let s = b"
		tabs:
			this is so
			# No comments
			cool
		spaces: # Comment
		    this is so
		    cool
		";

	let mut d = crate::Deserializer::from(buffered_reader::Memory::new(s));
	let t = <Test as serde::de::Deserialize>::deserialize(&mut d).unwrap();
	assert_eq!(t, Test{tabs: "this is so\n# No comments\ncool".into(), spaces: "this is so\ncool".into()})
}
