#[test]
fn test() {
	let s = b"
		foo
		none # comment
		None
		# comment
		none
		koala
		:
			none
		: # comment
			none
	";

	let mut d = crate::Deserializer::from(buffered_reader::Memory::new(s));
	let t = <Vec<Option<String>> as serde::de::Deserialize>::deserialize(&mut d).unwrap();
	assert_eq!(t, [
		Some("foo".into()),
		None,
		Some("None".into()),
		None,
		Some("koala".into()),
		None,
		None,
	])
}

#[test]
fn dict() {
	let s = b"
		dog:
			none # comment
		fish: # comment


		foo:
			foo
		koala: none
		meerkat:
			# foo
			none
		minx: # comment
			none
	";

	let mut d = crate::Deserializer::from(buffered_reader::Memory::new(s));
	let t = <std::collections::BTreeMap<String,Option<String>> as serde::de::Deserialize>::deserialize(&mut d).unwrap();
	assert_eq!(t, std::array::IntoIter::new([
		("dog".into(), None),
		("fish".into(), Some("".into())),
		("foo".into(), Some("foo".into())),
		("koala".into(), None),
		("meerkat".into(), Some("# foo\nnone".into())),
		("minx".into(), None),
	]).collect())
}
