#[test]
fn test() {
	let t: Vec<Option<String>> = crate::from_bytes(b"
		foo
		none # comment
		None
		# comment
		none
		koala
		:
			none
		: # comment
			none
	").unwrap();
	assert_eq!(t, [
		Some("foo".into()),
		None,
		Some("None".into()),
		None,
		Some("koala".into()),
		None,
		None,
	])
}

#[test]
fn dict() {
	let t: std::collections::BTreeMap<String,Option<String>> = crate::from_bytes(b"
		dog:
			none # comment
		fish: # comment


		foo:
			foo
		koala: none
		meerkat:
			# foo
			none
		minx: # comment
			none
	").unwrap();
	assert_eq!(t, std::array::IntoIter::new([
		("dog".into(), None),
		("fish".into(), Some("".into())),
		("foo".into(), Some("foo".into())),
		("koala".into(), None),
		("meerkat".into(), Some("# foo\nnone".into())),
		("minx".into(), None),
	]).collect())
}
