# Simple IRC Server

This is a simple IRC server written in the Rust languange. This server supports
basic set of IRC commands and basic user's mode and channel's modes.
This server have following features:

* an asynchronous design in the Tokio framework.
* a simple configuration in TOML format.
* a password hashing thanks Argon2 password hash.
* ability to predefine users, operators and channels.
* a domain name lookup for client hosts.
* TLS connections support thanks RusTLS and OpenSSL.

Because it is simple IRC server, unfortunatelly some commands have not been supported like: 
CONNECT, REHASH, RESTART, AUTHENTICATE, STATS. This server should be used to simple
installation only with local IRC environment.

## Build

A server can be easily build with Cargo package system. Following features can be enabled:

* dns_lookup - enable DNS lookup, it is uses Trust DNS resolver package.
* tls-rustls - enable TLS connection support.
* tls-openssl - enable TLS connection support thanks native OpenSSL library.

A tls-openssl should be used in old machines that doesn't support SSE2 instructions.
A rustls uses 'ring' crate that newer instruction set in X86 processors.

To build server with full support just enter:

```
cargo build --release --features=dns_lookup,tls_rustls
```

or

```
cargo build --release --features=dns_lookup,tls_openssl
```

You can build server without DNS lookup and TLS support by using simple command:

```
cargo build --release
```

To increase security you can specify environment variable PASSWORD_SALT during building
to provide own salt for Argon2 password hashing. It can be just some text.

## Configuration

The sample configuration is in config-example.toml that describes any field configuration.
Passwords should be filled by password hashes generated by using command:

```
simple-irc-server -g
```

or 

```
simple-irc-server -g -P password
```

Text after `Password hash:` should be put into password field.

## Run

You can run server by using command:

```
simple-irc-server -c your-config-file.toml
```

An IRC server can prints some logs to terminal output if no log file specified
in configuration.
