// Copyright 2021 Daniel Philip Watson
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#![allow(non_upper_case_globals, clippy::unreadable_literal)]

pub const pshufb_combine_table: [u8; 144] = [
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x80,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x80, 0x80,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x80, 0x80, 0x80,
    0x00, 0x01, 0x02, 0x03, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x80, 0x80, 0x80, 0x80,
    0x00, 0x01, 0x02, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x00, 0x01, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x00, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
];

// table modified and copied from http://graphics.stanford.edu/~seander/bithacks.html#CountBitsSetTable
pub const BitsSetTable256mul2: [u8; 256] = [
    0, 2, 2, 4, 2, 4, 4, 6, 2, 4, 4, 6, 4, 6, 6, 8, 2, 4, 4, 6, 4, 6, 6, 8, 4, 6, 6, 8, 6, 8, 8,
    10, 2, 4, 4, 6, 4, 6, 6, 8, 4, 6, 6, 8, 6, 8, 8, 10, 4, 6, 6, 8, 6, 8, 8, 10, 6, 8, 8, 10, 8,
    10, 10, 12, 2, 4, 4, 6, 4, 6, 6, 8, 4, 6, 6, 8, 6, 8, 8, 10, 4, 6, 6, 8, 6, 8, 8, 10, 6, 8, 8,
    10, 8, 10, 10, 12, 4, 6, 6, 8, 6, 8, 8, 10, 6, 8, 8, 10, 8, 10, 10, 12, 6, 8, 8, 10, 8, 10, 10,
    12, 8, 10, 10, 12, 10, 12, 12, 14, 2, 4, 4, 6, 4, 6, 6, 8, 4, 6, 6, 8, 6, 8, 8, 10, 4, 6, 6, 8,
    6, 8, 8, 10, 6, 8, 8, 10, 8, 10, 10, 12, 4, 6, 6, 8, 6, 8, 8, 10, 6, 8, 8, 10, 8, 10, 10, 12,
    6, 8, 8, 10, 8, 10, 10, 12, 8, 10, 10, 12, 10, 12, 12, 14, 4, 6, 6, 8, 6, 8, 8, 10, 6, 8, 8,
    10, 8, 10, 10, 12, 6, 8, 8, 10, 8, 10, 10, 12, 8, 10, 10, 12, 10, 12, 12, 14, 6, 8, 8, 10, 8,
    10, 10, 12, 8, 10, 10, 12, 10, 12, 12, 14, 8, 10, 10, 12, 10, 12, 12, 14, 10, 12, 12, 14, 12,
    14, 14, 16,
];

// 256 * 8 bytes = 2kB, easily fits in cache.
pub const thintable_epi8: [u64; 256] = [
    0x0706050403020100,
    0x0007060504030201,
    0x0007060504030200,
    0x0000070605040302,
    0x0007060504030100,
    0x0000070605040301,
    0x0000070605040300,
    0x0000000706050403,
    0x0007060504020100,
    0x0000070605040201,
    0x0000070605040200,
    0x0000000706050402,
    0x0000070605040100,
    0x0000000706050401,
    0x0000000706050400,
    0x0000000007060504,
    0x0007060503020100,
    0x0000070605030201,
    0x0000070605030200,
    0x0000000706050302,
    0x0000070605030100,
    0x0000000706050301,
    0x0000000706050300,
    0x0000000007060503,
    0x0000070605020100,
    0x0000000706050201,
    0x0000000706050200,
    0x0000000007060502,
    0x0000000706050100,
    0x0000000007060501,
    0x0000000007060500,
    0x0000000000070605,
    0x0007060403020100,
    0x0000070604030201,
    0x0000070604030200,
    0x0000000706040302,
    0x0000070604030100,
    0x0000000706040301,
    0x0000000706040300,
    0x0000000007060403,
    0x0000070604020100,
    0x0000000706040201,
    0x0000000706040200,
    0x0000000007060402,
    0x0000000706040100,
    0x0000000007060401,
    0x0000000007060400,
    0x0000000000070604,
    0x0000070603020100,
    0x0000000706030201,
    0x0000000706030200,
    0x0000000007060302,
    0x0000000706030100,
    0x0000000007060301,
    0x0000000007060300,
    0x0000000000070603,
    0x0000000706020100,
    0x0000000007060201,
    0x0000000007060200,
    0x0000000000070602,
    0x0000000007060100,
    0x0000000000070601,
    0x0000000000070600,
    0x0000000000000706,
    0x0007050403020100,
    0x0000070504030201,
    0x0000070504030200,
    0x0000000705040302,
    0x0000070504030100,
    0x0000000705040301,
    0x0000000705040300,
    0x0000000007050403,
    0x0000070504020100,
    0x0000000705040201,
    0x0000000705040200,
    0x0000000007050402,
    0x0000000705040100,
    0x0000000007050401,
    0x0000000007050400,
    0x0000000000070504,
    0x0000070503020100,
    0x0000000705030201,
    0x0000000705030200,
    0x0000000007050302,
    0x0000000705030100,
    0x0000000007050301,
    0x0000000007050300,
    0x0000000000070503,
    0x0000000705020100,
    0x0000000007050201,
    0x0000000007050200,
    0x0000000000070502,
    0x0000000007050100,
    0x0000000000070501,
    0x0000000000070500,
    0x0000000000000705,
    0x0000070403020100,
    0x0000000704030201,
    0x0000000704030200,
    0x0000000007040302,
    0x0000000704030100,
    0x0000000007040301,
    0x0000000007040300,
    0x0000000000070403,
    0x0000000704020100,
    0x0000000007040201,
    0x0000000007040200,
    0x0000000000070402,
    0x0000000007040100,
    0x0000000000070401,
    0x0000000000070400,
    0x0000000000000704,
    0x0000000703020100,
    0x0000000007030201,
    0x0000000007030200,
    0x0000000000070302,
    0x0000000007030100,
    0x0000000000070301,
    0x0000000000070300,
    0x0000000000000703,
    0x0000000007020100,
    0x0000000000070201,
    0x0000000000070200,
    0x0000000000000702,
    0x0000000000070100,
    0x0000000000000701,
    0x0000000000000700,
    0x0000000000000007,
    0x0006050403020100,
    0x0000060504030201,
    0x0000060504030200,
    0x0000000605040302,
    0x0000060504030100,
    0x0000000605040301,
    0x0000000605040300,
    0x0000000006050403,
    0x0000060504020100,
    0x0000000605040201,
    0x0000000605040200,
    0x0000000006050402,
    0x0000000605040100,
    0x0000000006050401,
    0x0000000006050400,
    0x0000000000060504,
    0x0000060503020100,
    0x0000000605030201,
    0x0000000605030200,
    0x0000000006050302,
    0x0000000605030100,
    0x0000000006050301,
    0x0000000006050300,
    0x0000000000060503,
    0x0000000605020100,
    0x0000000006050201,
    0x0000000006050200,
    0x0000000000060502,
    0x0000000006050100,
    0x0000000000060501,
    0x0000000000060500,
    0x0000000000000605,
    0x0000060403020100,
    0x0000000604030201,
    0x0000000604030200,
    0x0000000006040302,
    0x0000000604030100,
    0x0000000006040301,
    0x0000000006040300,
    0x0000000000060403,
    0x0000000604020100,
    0x0000000006040201,
    0x0000000006040200,
    0x0000000000060402,
    0x0000000006040100,
    0x0000000000060401,
    0x0000000000060400,
    0x0000000000000604,
    0x0000000603020100,
    0x0000000006030201,
    0x0000000006030200,
    0x0000000000060302,
    0x0000000006030100,
    0x0000000000060301,
    0x0000000000060300,
    0x0000000000000603,
    0x0000000006020100,
    0x0000000000060201,
    0x0000000000060200,
    0x0000000000000602,
    0x0000000000060100,
    0x0000000000000601,
    0x0000000000000600,
    0x0000000000000006,
    0x0000050403020100,
    0x0000000504030201,
    0x0000000504030200,
    0x0000000005040302,
    0x0000000504030100,
    0x0000000005040301,
    0x0000000005040300,
    0x0000000000050403,
    0x0000000504020100,
    0x0000000005040201,
    0x0000000005040200,
    0x0000000000050402,
    0x0000000005040100,
    0x0000000000050401,
    0x0000000000050400,
    0x0000000000000504,
    0x0000000503020100,
    0x0000000005030201,
    0x0000000005030200,
    0x0000000000050302,
    0x0000000005030100,
    0x0000000000050301,
    0x0000000000050300,
    0x0000000000000503,
    0x0000000005020100,
    0x0000000000050201,
    0x0000000000050200,
    0x0000000000000502,
    0x0000000000050100,
    0x0000000000000501,
    0x0000000000000500,
    0x0000000000000005,
    0x0000000403020100,
    0x0000000004030201,
    0x0000000004030200,
    0x0000000000040302,
    0x0000000004030100,
    0x0000000000040301,
    0x0000000000040300,
    0x0000000000000403,
    0x0000000004020100,
    0x0000000000040201,
    0x0000000000040200,
    0x0000000000000402,
    0x0000000000040100,
    0x0000000000000401,
    0x0000000000000400,
    0x0000000000000004,
    0x0000000003020100,
    0x0000000000030201,
    0x0000000000030200,
    0x0000000000000302,
    0x0000000000030100,
    0x0000000000000301,
    0x0000000000000300,
    0x0000000000000003,
    0x0000000000020100,
    0x0000000000000201,
    0x0000000000000200,
    0x0000000000000002,
    0x0000000000000100,
    0x0000000000000001,
    0x0000000000000000,
    0x0000000000000000,
];

pub const mask128_epi16: [u8; 256 * 16] = [
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2,
    0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1,
    0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x4, 0x5, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0x0, 0x1, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x6, 0x7, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x4,
    0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x6, 0x7, 0xc, 0xd, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0x2, 0x3, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x4,
    0x5, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0xc, 0xd, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0xc, 0xd, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0,
    0x1, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8,
    0x9, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x8,
    0x9, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x8, 0x9, 0xa, 0xb,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x8, 0x9, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x4, 0x5,
    0x6, 0x7, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6,
    0x7, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x6, 0x7, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0x6, 0x7, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2,
    0x3, 0x4, 0x5, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x4, 0x5,
    0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x4, 0x5, 0xa, 0xb, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0x0, 0x1, 0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xa, 0xb, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1,
    0x6, 0x7, 0x8, 0x9, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x6, 0x7, 0x8, 0x9, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0x4, 0x5, 0x8, 0x9, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x8, 0x9, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x8, 0x9,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x8, 0x9, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x8, 0x9, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x4, 0x5, 0x6,
    0x7, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0x6, 0x7, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x6, 0x7, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0x6, 0x7, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3,
    0x4, 0x5, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x4, 0x5, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x4, 0x5, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0x2, 0x3, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf,
    0xe, 0xf, 0x0, 0x1, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe,
    0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc,
    0xd, 0xc, 0xd, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd,
    0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd,
    0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc,
    0xd, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1,
    0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x2, 0x3, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc,
    0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd,
    0xc, 0xd, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0,
    0x1, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x4, 0x5, 0x6, 0x7,
    0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0xa,
    0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd,
    0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc,
    0xd, 0xc, 0xd, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x2, 0x3, 0x4,
    0x5, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x4, 0x5, 0xa, 0xb,
    0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc,
    0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x2, 0x3, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd,
    0xc, 0xd, 0xc, 0xd, 0x2, 0x3, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc,
    0xd, 0x0, 0x1, 0xa, 0xb, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xa, 0xb,
    0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xc,
    0xd, 0xc, 0xd, 0xc, 0xd, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd,
    0xc, 0xd, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x2,
    0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x6, 0x7,
    0x8, 0x9, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xc,
    0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd,
    0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc,
    0xd, 0xc, 0xd, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd,
    0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x2,
    0x3, 0x8, 0x9, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x2, 0x3, 0x8, 0x9, 0xc, 0xd,
    0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x8, 0x9, 0xc, 0xd, 0xc, 0xd, 0xc,
    0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x8, 0x9, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd,
    0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc,
    0xd, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1,
    0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x4, 0x5, 0x6, 0x7, 0xc,
    0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0xc, 0xd,
    0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x2, 0x3, 0x6, 0x7, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc,
    0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x6, 0x7, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd,
    0xc, 0xd, 0x6, 0x7, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x5, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x2, 0x3, 0x4, 0x5,
    0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x4, 0x5, 0xc, 0xd, 0xc,
    0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x4, 0x5, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd,
    0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x2, 0x3, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc,
    0xd, 0xc, 0xd, 0x2, 0x3, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd,
    0x0, 0x1, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc,
    0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xa, 0xb,
    0xa, 0xb, 0xa, 0xb, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa,
    0xb, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x2, 0x3,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x0, 0x1, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xa, 0xb,
    0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xa,
    0xb, 0xa, 0xb, 0xa, 0xb, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb,
    0xa, 0xb, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x4,
    0x5, 0x8, 0x9, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x0, 0x1, 0x2, 0x3,
    0x8, 0x9, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xa,
    0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x0, 0x1, 0x8, 0x9, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb,
    0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x8, 0x9, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa,
    0xb, 0xa, 0xb, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x0, 0x1, 0x4,
    0x5, 0x6, 0x7, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb,
    0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb, 0xa,
    0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb,
    0xa, 0xb, 0xa, 0xb, 0x0, 0x1, 0x6, 0x7, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa,
    0xb, 0x6, 0x7, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x2, 0x3, 0x4, 0x5, 0xa,
    0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x0, 0x1, 0x4, 0x5, 0xa, 0xb, 0xa, 0xb,
    0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x4, 0x5, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa,
    0xb, 0xa, 0xb, 0xa, 0xb, 0x0, 0x1, 0x2, 0x3, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb,
    0xa, 0xb, 0x2, 0x3, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x0,
    0x1, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb,
    0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0xa, 0xb, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x8, 0x9,
    0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8,
    0x9, 0x8, 0x9, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9,
    0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x2, 0x3, 0x6,
    0x7, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x0, 0x1, 0x6, 0x7, 0x8, 0x9,
    0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x6, 0x7, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8,
    0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9,
    0x8, 0x9, 0x8, 0x9, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8,
    0x9, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x4, 0x5,
    0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x0, 0x1, 0x2, 0x3, 0x8,
    0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x2, 0x3, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9,
    0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x0, 0x1, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8,
    0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9,
    0x8, 0x9, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x0, 0x1, 0x4, 0x5,
    0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x4, 0x5, 0x6, 0x7, 0x6, 0x7, 0x6,
    0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7,
    0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x2, 0x3, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6,
    0x7, 0x6, 0x7, 0x0, 0x1, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7,
    0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x6, 0x7, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x2, 0x3, 0x4, 0x5, 0x4, 0x5,
    0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x0, 0x1, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x4,
    0x5, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5, 0x4, 0x5,
    0x4, 0x5, 0x4, 0x5, 0x0, 0x1, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2,
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x0, 0x1,
    0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
];

pub const mask128_epi32: [u8; 16 * 16] = [
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xc, 0xd, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xc, 0xd, 0xe, 0xf, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xc,
    0xd, 0xe, 0xf, 0xc, 0xd, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf,
    0xc, 0xd, 0xe, 0xf, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xc, 0xd, 0xe, 0xf, 0xc, 0xd, 0xe,
    0xf, 0x0, 0x1, 0x2, 0x3, 0xc, 0xd, 0xe, 0xf, 0xc, 0xd, 0xe, 0xf, 0xc, 0xd, 0xe, 0xf, 0xc, 0xd,
    0xe, 0xf, 0xc, 0xd, 0xe, 0xf, 0xc, 0xd, 0xe, 0xf, 0xc, 0xd, 0xe, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0x8, 0x9, 0xa, 0xb, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0x8, 0x9, 0xa, 0xb, 0x8, 0x9, 0xa, 0xb, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0x8, 0x9, 0xa,
    0xb, 0x8, 0x9, 0xa, 0xb, 0x8, 0x9, 0xa, 0xb, 0x8, 0x9, 0xa, 0xb, 0x8, 0x9, 0xa, 0xb, 0x8, 0x9,
    0xa, 0xb, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x4, 0x5, 0x6, 0x7, 0x4, 0x5, 0x6, 0x7, 0x4,
    0x5, 0x6, 0x7, 0x4, 0x5, 0x6, 0x7, 0x4, 0x5, 0x6, 0x7, 0x4, 0x5, 0x6, 0x7, 0x0, 0x1, 0x2, 0x3,
    0x0, 0x1, 0x2, 0x3, 0x0, 0x1, 0x2, 0x3, 0x0, 0x1, 0x2, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
];

pub const mask256_epi32: [u32; 256 * 8] = [
    0, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 7, 0, 2, 3, 4, 5, 6, 7, 7, 2, 3, 4, 5, 6, 7, 7, 7,
    0, 1, 3, 4, 5, 6, 7, 7, 1, 3, 4, 5, 6, 7, 7, 7, 0, 3, 4, 5, 6, 7, 7, 7, 3, 4, 5, 6, 7, 7, 7, 7,
    0, 1, 2, 4, 5, 6, 7, 7, 1, 2, 4, 5, 6, 7, 7, 7, 0, 2, 4, 5, 6, 7, 7, 7, 2, 4, 5, 6, 7, 7, 7, 7,
    0, 1, 4, 5, 6, 7, 7, 7, 1, 4, 5, 6, 7, 7, 7, 7, 0, 4, 5, 6, 7, 7, 7, 7, 4, 5, 6, 7, 7, 7, 7, 7,
    0, 1, 2, 3, 5, 6, 7, 7, 1, 2, 3, 5, 6, 7, 7, 7, 0, 2, 3, 5, 6, 7, 7, 7, 2, 3, 5, 6, 7, 7, 7, 7,
    0, 1, 3, 5, 6, 7, 7, 7, 1, 3, 5, 6, 7, 7, 7, 7, 0, 3, 5, 6, 7, 7, 7, 7, 3, 5, 6, 7, 7, 7, 7, 7,
    0, 1, 2, 5, 6, 7, 7, 7, 1, 2, 5, 6, 7, 7, 7, 7, 0, 2, 5, 6, 7, 7, 7, 7, 2, 5, 6, 7, 7, 7, 7, 7,
    0, 1, 5, 6, 7, 7, 7, 7, 1, 5, 6, 7, 7, 7, 7, 7, 0, 5, 6, 7, 7, 7, 7, 7, 5, 6, 7, 7, 7, 7, 7, 7,
    0, 1, 2, 3, 4, 6, 7, 7, 1, 2, 3, 4, 6, 7, 7, 7, 0, 2, 3, 4, 6, 7, 7, 7, 2, 3, 4, 6, 7, 7, 7, 7,
    0, 1, 3, 4, 6, 7, 7, 7, 1, 3, 4, 6, 7, 7, 7, 7, 0, 3, 4, 6, 7, 7, 7, 7, 3, 4, 6, 7, 7, 7, 7, 7,
    0, 1, 2, 4, 6, 7, 7, 7, 1, 2, 4, 6, 7, 7, 7, 7, 0, 2, 4, 6, 7, 7, 7, 7, 2, 4, 6, 7, 7, 7, 7, 7,
    0, 1, 4, 6, 7, 7, 7, 7, 1, 4, 6, 7, 7, 7, 7, 7, 0, 4, 6, 7, 7, 7, 7, 7, 4, 6, 7, 7, 7, 7, 7, 7,
    0, 1, 2, 3, 6, 7, 7, 7, 1, 2, 3, 6, 7, 7, 7, 7, 0, 2, 3, 6, 7, 7, 7, 7, 2, 3, 6, 7, 7, 7, 7, 7,
    0, 1, 3, 6, 7, 7, 7, 7, 1, 3, 6, 7, 7, 7, 7, 7, 0, 3, 6, 7, 7, 7, 7, 7, 3, 6, 7, 7, 7, 7, 7, 7,
    0, 1, 2, 6, 7, 7, 7, 7, 1, 2, 6, 7, 7, 7, 7, 7, 0, 2, 6, 7, 7, 7, 7, 7, 2, 6, 7, 7, 7, 7, 7, 7,
    0, 1, 6, 7, 7, 7, 7, 7, 1, 6, 7, 7, 7, 7, 7, 7, 0, 6, 7, 7, 7, 7, 7, 7, 6, 7, 7, 7, 7, 7, 7, 7,
    0, 1, 2, 3, 4, 5, 7, 7, 1, 2, 3, 4, 5, 7, 7, 7, 0, 2, 3, 4, 5, 7, 7, 7, 2, 3, 4, 5, 7, 7, 7, 7,
    0, 1, 3, 4, 5, 7, 7, 7, 1, 3, 4, 5, 7, 7, 7, 7, 0, 3, 4, 5, 7, 7, 7, 7, 3, 4, 5, 7, 7, 7, 7, 7,
    0, 1, 2, 4, 5, 7, 7, 7, 1, 2, 4, 5, 7, 7, 7, 7, 0, 2, 4, 5, 7, 7, 7, 7, 2, 4, 5, 7, 7, 7, 7, 7,
    0, 1, 4, 5, 7, 7, 7, 7, 1, 4, 5, 7, 7, 7, 7, 7, 0, 4, 5, 7, 7, 7, 7, 7, 4, 5, 7, 7, 7, 7, 7, 7,
    0, 1, 2, 3, 5, 7, 7, 7, 1, 2, 3, 5, 7, 7, 7, 7, 0, 2, 3, 5, 7, 7, 7, 7, 2, 3, 5, 7, 7, 7, 7, 7,
    0, 1, 3, 5, 7, 7, 7, 7, 1, 3, 5, 7, 7, 7, 7, 7, 0, 3, 5, 7, 7, 7, 7, 7, 3, 5, 7, 7, 7, 7, 7, 7,
    0, 1, 2, 5, 7, 7, 7, 7, 1, 2, 5, 7, 7, 7, 7, 7, 0, 2, 5, 7, 7, 7, 7, 7, 2, 5, 7, 7, 7, 7, 7, 7,
    0, 1, 5, 7, 7, 7, 7, 7, 1, 5, 7, 7, 7, 7, 7, 7, 0, 5, 7, 7, 7, 7, 7, 7, 5, 7, 7, 7, 7, 7, 7, 7,
    0, 1, 2, 3, 4, 7, 7, 7, 1, 2, 3, 4, 7, 7, 7, 7, 0, 2, 3, 4, 7, 7, 7, 7, 2, 3, 4, 7, 7, 7, 7, 7,
    0, 1, 3, 4, 7, 7, 7, 7, 1, 3, 4, 7, 7, 7, 7, 7, 0, 3, 4, 7, 7, 7, 7, 7, 3, 4, 7, 7, 7, 7, 7, 7,
    0, 1, 2, 4, 7, 7, 7, 7, 1, 2, 4, 7, 7, 7, 7, 7, 0, 2, 4, 7, 7, 7, 7, 7, 2, 4, 7, 7, 7, 7, 7, 7,
    0, 1, 4, 7, 7, 7, 7, 7, 1, 4, 7, 7, 7, 7, 7, 7, 0, 4, 7, 7, 7, 7, 7, 7, 4, 7, 7, 7, 7, 7, 7, 7,
    0, 1, 2, 3, 7, 7, 7, 7, 1, 2, 3, 7, 7, 7, 7, 7, 0, 2, 3, 7, 7, 7, 7, 7, 2, 3, 7, 7, 7, 7, 7, 7,
    0, 1, 3, 7, 7, 7, 7, 7, 1, 3, 7, 7, 7, 7, 7, 7, 0, 3, 7, 7, 7, 7, 7, 7, 3, 7, 7, 7, 7, 7, 7, 7,
    0, 1, 2, 7, 7, 7, 7, 7, 1, 2, 7, 7, 7, 7, 7, 7, 0, 2, 7, 7, 7, 7, 7, 7, 2, 7, 7, 7, 7, 7, 7, 7,
    0, 1, 7, 7, 7, 7, 7, 7, 1, 7, 7, 7, 7, 7, 7, 7, 0, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    0, 1, 2, 3, 4, 5, 6, 6, 1, 2, 3, 4, 5, 6, 6, 6, 0, 2, 3, 4, 5, 6, 6, 6, 2, 3, 4, 5, 6, 6, 6, 6,
    0, 1, 3, 4, 5, 6, 6, 6, 1, 3, 4, 5, 6, 6, 6, 6, 0, 3, 4, 5, 6, 6, 6, 6, 3, 4, 5, 6, 6, 6, 6, 6,
    0, 1, 2, 4, 5, 6, 6, 6, 1, 2, 4, 5, 6, 6, 6, 6, 0, 2, 4, 5, 6, 6, 6, 6, 2, 4, 5, 6, 6, 6, 6, 6,
    0, 1, 4, 5, 6, 6, 6, 6, 1, 4, 5, 6, 6, 6, 6, 6, 0, 4, 5, 6, 6, 6, 6, 6, 4, 5, 6, 6, 6, 6, 6, 6,
    0, 1, 2, 3, 5, 6, 6, 6, 1, 2, 3, 5, 6, 6, 6, 6, 0, 2, 3, 5, 6, 6, 6, 6, 2, 3, 5, 6, 6, 6, 6, 6,
    0, 1, 3, 5, 6, 6, 6, 6, 1, 3, 5, 6, 6, 6, 6, 6, 0, 3, 5, 6, 6, 6, 6, 6, 3, 5, 6, 6, 6, 6, 6, 6,
    0, 1, 2, 5, 6, 6, 6, 6, 1, 2, 5, 6, 6, 6, 6, 6, 0, 2, 5, 6, 6, 6, 6, 6, 2, 5, 6, 6, 6, 6, 6, 6,
    0, 1, 5, 6, 6, 6, 6, 6, 1, 5, 6, 6, 6, 6, 6, 6, 0, 5, 6, 6, 6, 6, 6, 6, 5, 6, 6, 6, 6, 6, 6, 6,
    0, 1, 2, 3, 4, 6, 6, 6, 1, 2, 3, 4, 6, 6, 6, 6, 0, 2, 3, 4, 6, 6, 6, 6, 2, 3, 4, 6, 6, 6, 6, 6,
    0, 1, 3, 4, 6, 6, 6, 6, 1, 3, 4, 6, 6, 6, 6, 6, 0, 3, 4, 6, 6, 6, 6, 6, 3, 4, 6, 6, 6, 6, 6, 6,
    0, 1, 2, 4, 6, 6, 6, 6, 1, 2, 4, 6, 6, 6, 6, 6, 0, 2, 4, 6, 6, 6, 6, 6, 2, 4, 6, 6, 6, 6, 6, 6,
    0, 1, 4, 6, 6, 6, 6, 6, 1, 4, 6, 6, 6, 6, 6, 6, 0, 4, 6, 6, 6, 6, 6, 6, 4, 6, 6, 6, 6, 6, 6, 6,
    0, 1, 2, 3, 6, 6, 6, 6, 1, 2, 3, 6, 6, 6, 6, 6, 0, 2, 3, 6, 6, 6, 6, 6, 2, 3, 6, 6, 6, 6, 6, 6,
    0, 1, 3, 6, 6, 6, 6, 6, 1, 3, 6, 6, 6, 6, 6, 6, 0, 3, 6, 6, 6, 6, 6, 6, 3, 6, 6, 6, 6, 6, 6, 6,
    0, 1, 2, 6, 6, 6, 6, 6, 1, 2, 6, 6, 6, 6, 6, 6, 0, 2, 6, 6, 6, 6, 6, 6, 2, 6, 6, 6, 6, 6, 6, 6,
    0, 1, 6, 6, 6, 6, 6, 6, 1, 6, 6, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    0, 1, 2, 3, 4, 5, 5, 5, 1, 2, 3, 4, 5, 5, 5, 5, 0, 2, 3, 4, 5, 5, 5, 5, 2, 3, 4, 5, 5, 5, 5, 5,
    0, 1, 3, 4, 5, 5, 5, 5, 1, 3, 4, 5, 5, 5, 5, 5, 0, 3, 4, 5, 5, 5, 5, 5, 3, 4, 5, 5, 5, 5, 5, 5,
    0, 1, 2, 4, 5, 5, 5, 5, 1, 2, 4, 5, 5, 5, 5, 5, 0, 2, 4, 5, 5, 5, 5, 5, 2, 4, 5, 5, 5, 5, 5, 5,
    0, 1, 4, 5, 5, 5, 5, 5, 1, 4, 5, 5, 5, 5, 5, 5, 0, 4, 5, 5, 5, 5, 5, 5, 4, 5, 5, 5, 5, 5, 5, 5,
    0, 1, 2, 3, 5, 5, 5, 5, 1, 2, 3, 5, 5, 5, 5, 5, 0, 2, 3, 5, 5, 5, 5, 5, 2, 3, 5, 5, 5, 5, 5, 5,
    0, 1, 3, 5, 5, 5, 5, 5, 1, 3, 5, 5, 5, 5, 5, 5, 0, 3, 5, 5, 5, 5, 5, 5, 3, 5, 5, 5, 5, 5, 5, 5,
    0, 1, 2, 5, 5, 5, 5, 5, 1, 2, 5, 5, 5, 5, 5, 5, 0, 2, 5, 5, 5, 5, 5, 5, 2, 5, 5, 5, 5, 5, 5, 5,
    0, 1, 5, 5, 5, 5, 5, 5, 1, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    0, 1, 2, 3, 4, 4, 4, 4, 1, 2, 3, 4, 4, 4, 4, 4, 0, 2, 3, 4, 4, 4, 4, 4, 2, 3, 4, 4, 4, 4, 4, 4,
    0, 1, 3, 4, 4, 4, 4, 4, 1, 3, 4, 4, 4, 4, 4, 4, 0, 3, 4, 4, 4, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4,
    0, 1, 2, 4, 4, 4, 4, 4, 1, 2, 4, 4, 4, 4, 4, 4, 0, 2, 4, 4, 4, 4, 4, 4, 2, 4, 4, 4, 4, 4, 4, 4,
    0, 1, 4, 4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    0, 1, 2, 3, 3, 3, 3, 3, 1, 2, 3, 3, 3, 3, 3, 3, 0, 2, 3, 3, 3, 3, 3, 3, 2, 3, 3, 3, 3, 3, 3, 3,
    0, 1, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    0, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
];
