// Copyright 2021 Daniel Philip Watson
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#![allow(non_upper_case_globals)]

pub const mask128_epi8: [u8; (1 << 16) * 16] = [
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5,
    0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5,
    0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5,
    0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5,
    0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5,
    0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x9,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x9, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x9, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x9, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5,
    0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5,
    0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x7, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5,
    0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5,
    0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5,
    0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x6, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x5, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x8, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5,
    0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6,
    0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6,
    0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6,
    0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x6, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5,
    0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x5, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5,
    0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5,
    0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0xa, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0xa,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0xa, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0xa, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0xa, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x6, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x5, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5,
    0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6,
    0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6,
    0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6,
    0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x6, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6,
    0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5,
    0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x5, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x7, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5,
    0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x5, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x6, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x9, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x9, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x9,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x9, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x9, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x9, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7,
    0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5,
    0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6,
    0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7,
    0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5,
    0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7,
    0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7,
    0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5,
    0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5,
    0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7,
    0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5,
    0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5,
    0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6,
    0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5,
    0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6,
    0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5,
    0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5,
    0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x8, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5,
    0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6,
    0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x6, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5,
    0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5,
    0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5,
    0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x5, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x7, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5,
    0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x5, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5,
    0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x6, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x5, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0xb, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0xb,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0xb, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0xb, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0xb, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xb, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5,
    0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5,
    0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6,
    0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6,
    0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6,
    0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6,
    0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6,
    0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x7, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5,
    0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x5, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x6, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x5, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x9, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x9, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x9, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x9, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x9,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6,
    0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5,
    0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6,
    0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6,
    0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x6, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5,
    0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x5, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x7, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5,
    0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5,
    0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5,
    0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5,
    0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5,
    0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6,
    0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5,
    0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5,
    0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5,
    0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5,
    0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5,
    0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5,
    0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x6, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0xa, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x5, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0xa,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0xa, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0xa, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0xa, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xa, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6,
    0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6,
    0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x6, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5,
    0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5,
    0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x7, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5,
    0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x5, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x6, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x5, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6,
    0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5,
    0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6,
    0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6,
    0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6,
    0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5,
    0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5,
    0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x9, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x9, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x9, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x9,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x9, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x9, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6,
    0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6,
    0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6,
    0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6,
    0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5,
    0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x5, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x7, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5,
    0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x5, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x6, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x5, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x8, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6,
    0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5,
    0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x5, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6,
    0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x6, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6,
    0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5,
    0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5,
    0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5,
    0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5,
    0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5,
    0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0xc, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0xc, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0xc,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0xc, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0xc, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xc, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5,
    0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x6, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x5, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x8, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6,
    0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5,
    0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5,
    0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6,
    0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x6, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5,
    0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x5, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x7, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5,
    0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x5, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5,
    0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5,
    0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x9, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x9, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x9, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x9,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x9, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x9, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6,
    0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6,
    0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6,
    0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6,
    0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5,
    0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5,
    0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5,
    0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6,
    0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x5, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6,
    0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6,
    0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6,
    0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x6, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5,
    0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x5, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x7, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5,
    0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x5, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x6, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x5, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0xa, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0xa, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0xa, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0xa, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0xa,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xa, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6,
    0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5,
    0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5,
    0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5,
    0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5,
    0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6,
    0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5,
    0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5,
    0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5,
    0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5,
    0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x5, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x7, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5,
    0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5,
    0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5,
    0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x5, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x6, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x5, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x9, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x9, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x9,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x9, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x9, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x9, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6,
    0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x5, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6,
    0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6,
    0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x6, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5,
    0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x5, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5,
    0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5,
    0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6,
    0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6,
    0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5,
    0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6,
    0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6,
    0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6,
    0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6,
    0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5,
    0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x6, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0xb, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x5, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0xb, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0xb, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0xb,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0xb, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xb, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5,
    0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x5, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x7, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5,
    0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x5, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x6, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5,
    0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6,
    0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5,
    0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5,
    0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5,
    0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5,
    0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5,
    0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5,
    0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x9,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x9, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x9, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x9, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x9, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x9, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5,
    0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6,
    0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x6, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5,
    0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5,
    0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5,
    0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x5, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x7, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5,
    0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5,
    0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x6, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x5, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x8, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6,
    0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5,
    0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x5, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5,
    0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6,
    0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6,
    0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6,
    0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5,
    0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0xa, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0xa, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0xa, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0xa,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0xa, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xa, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6,
    0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6,
    0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x7, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5,
    0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x5, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x6, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x5, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x8, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6,
    0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5,
    0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x5, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6,
    0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6,
    0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x6, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5,
    0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x5, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x7, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5,
    0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5,
    0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5,
    0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x9,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x9, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x9, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x9, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x9, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x9, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5,
    0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7,
    0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7,
    0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7,
    0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7,
    0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6,
    0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5,
    0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5,
    0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5,
    0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7,
    0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5,
    0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7,
    0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6,
    0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5,
    0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5,
    0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5,
    0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5,
    0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x5, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x8, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5,
    0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6,
    0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5,
    0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5,
    0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x5, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6,
    0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6,
    0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x6, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5,
    0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x5, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5,
    0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x7, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5,
    0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x5, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x6, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x5, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0xd, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0xd, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0xd,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0xd, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0xd, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xd, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5,
    0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5,
    0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x5, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x7, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5,
    0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x5, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x6, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x5, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x9,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x9, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x9, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x9, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x9, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x9, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5,
    0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x5, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x6, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5,
    0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5,
    0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5,
    0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5,
    0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6,
    0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5,
    0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6,
    0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5,
    0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5,
    0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x7, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5,
    0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5,
    0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x5, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x6, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x5, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0xa, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0xa,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0xa, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0xa, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xa, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x5, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x7, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5,
    0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x5, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5,
    0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5,
    0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6,
    0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6,
    0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6,
    0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6,
    0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5,
    0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5,
    0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x9, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x5, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x9, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x9,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x9, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x9, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x9, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5,
    0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6,
    0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6,
    0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6,
    0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6,
    0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x6, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5,
    0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x5, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x7, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5,
    0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x5, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x6, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x5, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x8, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5,
    0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5,
    0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6,
    0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5,
    0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6,
    0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6,
    0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5,
    0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5,
    0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5,
    0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5,
    0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0xb,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0xb, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0xb, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0xb, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xb, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5,
    0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5,
    0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x7, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5,
    0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5,
    0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5,
    0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x5, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x6, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x5, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x8, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x8,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x8, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x8, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6,
    0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x5, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6,
    0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6,
    0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x6, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5,
    0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x5, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5,
    0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5,
    0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x9, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x9,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x9, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x9, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x9, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x9, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6,
    0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5,
    0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x8,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6,
    0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x8,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6,
    0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6,
    0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6,
    0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x8, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5,
    0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x8,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x8,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x8, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x8, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x8, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x6, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x8,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x8,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x8, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x8, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x5, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x8, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x8,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x8, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x8, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x8,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x8,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x8, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6,
    0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5,
    0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6,
    0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6,
    0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x5, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6,
    0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x6, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6,
    0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5,
    0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x5, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x7, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5,
    0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5,
    0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x5, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x6, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0xa, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0xa, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0xa,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0xa, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0xa, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xa, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6,
    0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7,
    0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5,
    0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7,
    0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7,
    0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5,
    0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5,
    0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7,
    0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4,
    0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5,
    0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5,
    0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6,
    0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5,
    0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x4, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x4, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6,
    0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x4, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x4, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x4, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x4, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x8,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x4, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5,
    0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5,
    0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x4, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4,
    0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x4, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x4, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x8, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x4, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4,
    0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x8, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x8, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x8, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x8, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5,
    0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4,
    0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5,
    0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x4, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4,
    0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6,
    0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x4, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x6, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x4, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5,
    0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4,
    0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5,
    0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5,
    0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x5, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x4, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x4, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x4, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x7, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x4, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x4, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5,
    0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x5, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5,
    0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x4, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x3, 0x4, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4,
    0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x4, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x4, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x3, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x3, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x6, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4,
    0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x3, 0x4, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x4, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4,
    0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x3, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x3, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x3, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x5, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x3, 0x4, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3,
    0x4, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x9, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x4, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x4, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x9,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x9, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x3, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x3, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x9, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x9, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x9, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4,
    0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6,
    0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x4, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5,
    0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x7, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x3, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x3, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x7, 0x8,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x5, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5,
    0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x7, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x3, 0x4, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6,
    0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x7, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x4, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x4, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6,
    0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x7, 0x8,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x4, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x3, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x3, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x7,
    0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x3, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3,
    0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6,
    0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x7, 0x8, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x7,
    0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x7, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x2, 0x3, 0x4, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x3, 0x4, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x7,
    0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x7, 0x8, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x2, 0x4, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x7,
    0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x7, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x4, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x2, 0x3, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3,
    0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x7, 0x8,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x3, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5,
    0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x7,
    0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x7, 0x8,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x2, 0x3, 0x4, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3,
    0x4, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x7, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x2, 0x4, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2,
    0x4, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x7, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x7, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x4, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x2, 0x3, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x7,
    0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x7, 0x8, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x3, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x3, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x7, 0x8,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x7, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x2, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x7,
    0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x7, 0x8, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x7, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2,
    0x3, 0x4, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4,
    0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x6, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x1, 0x2, 0x4, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4,
    0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x6, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x4, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x4, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1,
    0x2, 0x3, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x6,
    0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x6, 0x8, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x1, 0x3, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x3, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x5, 0x6, 0x8,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x5, 0x6, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x2, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x1, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x5, 0x6,
    0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x5, 0x6, 0x8, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x5, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x2, 0x3, 0x4, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3,
    0x4, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x6,
    0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x6, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x1, 0x2, 0x4, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1,
    0x2, 0x4, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x6,
    0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x6, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x0, 0x4, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x4, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2,
    0x3, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x6, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x1, 0x3, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3,
    0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x3, 0x6, 0x8, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x6, 0x8, 0xc, 0xe, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x2, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0,
    0x1, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x6, 0x8, 0xc,
    0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x6, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x4, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0x0, 0x2, 0x3, 0x4, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x3, 0x4,
    0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x3, 0x4, 0x5, 0x8,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x3, 0x4, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x3, 0x4, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0x3, 0x4, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0x0, 0x1, 0x2, 0x4, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2,
    0x4, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x4, 0x5, 0x8,
    0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x2, 0x4, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x4, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x4, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf,
    0xf, 0xf, 0x0, 0x4, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x4,
    0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x1, 0x2, 0x3,
    0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x1, 0x2, 0x3, 0x5, 0x8, 0xc, 0xe,
    0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0x0, 0x2, 0x3, 0x5, 0x8, 0xc, 0xe, 0xf, 0xf, 0xf,
    0xf, 0xf