// This file is part of simavr-section, a Rust port of the *simavr*
// header `avr_mcu_section.h`.
//
// Copyright 2021 Andrew Dona-Couch
//
// simavr-section is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// simavr-section is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#![no_std]
#![allow(non_camel_case_types, non_upper_case_globals)]

include!(concat!(env!("OUT_DIR"), "/bindings.rs"));

pub mod libc {
    pub type c_uint = u16;
    pub type c_char = u8;
    pub use core::ffi::c_void;
}

#[repr(transparent)]
pub struct UnsafeVcdTrace(pub avr_mmcu_vcd_trace_t);

unsafe impl Sync for UnsafeVcdTrace {}
