// This file is part of simavr-section, a Rust port of the *simavr*
// header `avr_mcu_section.h`.
//
// Copyright 2021 Andrew Dona-Couch
//
// simavr-section is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// simavr-section is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

use bindgen::Builder;

fn main() {
    println!("Generating bindings!");

    let header_path = std::path::PathBuf::from(std::env::var("CARGO_MANIFEST_DIR").unwrap())
        .join("simavr")
        .join("simavr")
        .join("sim")
        .join("avr")
        .join("avr_mcu_section.h")
        .to_str()
        .unwrap()
        .to_string();

    let bindings = Builder::default()
        .header(header_path)
        .use_core()
        .ctypes_prefix("crate::libc")
        .clang_arg("-I/usr/lib/avr/include")
        .clang_arg("-mmcu=atmega328p")
        .clang_arg("-D__AVR__")
        .generate()
        .expect("could not generate bindings");

    // Write the bindings to the $OUT_DIR/bindings.rs file.
    let out_path = std::path::PathBuf::from(std::env::var("OUT_DIR").unwrap());
    bindings
        .write_to_file(out_path.join("bindings.rs"))
        .expect("Couldn't write bindings!");

    println!("Generating bindings complete.");
}
