# signal-child

[![crates.io](https://img.shields.io/crates/v/signal-child.svg)](https://crates.io/crates/signal-child)
[![docs.rs](https://docs.rs/signal-child/badge.svg)](https://docs.rs/signal-child)
![Minimum Supported Rust Version](https://img.shields.io/badge/rustc-1.34.0-red)

A little library to easily signal other process with no dependencies on
Unix-like systems.

## Example

```rust
use std::process::Command;
use signal_child::Signalable;

// Spawn child process
let mut child = Command::new("sleep")
    .arg("1000")
    .spawn()
    .expect("Error spawning sleep process");
// Sing SIGINT to the child.
child.interrupt().expect("Error interrupting child");
```

## Contributing

Please send any and all patches, bugs, and questions to my public inbox
[~zethra/public-inbox@lists.sr.ht](mailto:~zethra/public-inbox@lists.sr.ht)
