use std::error::Error;
use std::fmt::{self, Display, Formatter};

/// Error returned when an ivalid signal value is used
#[derive(Debug, Clone, Copy, PartialEq, Eq)]
pub struct InvalidSignal;

impl Display for InvalidSignal {
    fn fmt(&self, f: &mut Formatter<'_>) -> fmt::Result {
        write!(f, "Invalid signal value")
    }
}

impl Error for InvalidSignal {}
