#[allow(dead_code)]
pub mod timelock_controller {
  # [rustfmt :: skip] use ethcontract as ethcontract ;
  #[doc = "Generated by `ethcontract`"]
  #[derive(Clone)]
  pub struct Contract {
    methods: Methods,
  }
  impl Contract {
    #[doc = r" Retrieves the truffle artifact used to generate the type safe"]
    #[doc = r" API for this contract."]
    pub fn artifact() -> &'static self::ethcontract::Artifact {
      use self::ethcontract::private::lazy_static;
      use self::ethcontract::Artifact;
      lazy_static! {
        pub static ref ARTIFACT: Artifact = {
          # [allow (unused_mut)] let mut artifact = Artifact :: from_json ("{\n  \"_format\": \"hh-sol-artifact-1\",\n  \"contractName\": \"TimelockController\",\n  \"sourceName\": \"contracts/governance/TimelockController.sol\",\n  \"abi\": [\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"minDelay\",\n          \"type\": \"uint256\"\n        },\n        {\n          \"internalType\": \"address[]\",\n          \"name\": \"proposers\",\n          \"type\": \"address[]\"\n        },\n        {\n          \"internalType\": \"address[]\",\n          \"name\": \"executors\",\n          \"type\": \"address[]\"\n        }\n      ],\n      \"stateMutability\": \"nonpayable\",\n      \"type\": \"constructor\"\n    },\n    {\n      \"anonymous\": false,\n      \"inputs\": [\n        {\n          \"indexed\": true,\n          \"internalType\": \"bytes32\",\n          \"name\": \"id\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"uint256\",\n          \"name\": \"index\",\n          \"type\": \"uint256\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"address\",\n          \"name\": \"target\",\n          \"type\": \"address\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"uint256\",\n          \"name\": \"value\",\n          \"type\": \"uint256\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"bytes\",\n          \"name\": \"data\",\n          \"type\": \"bytes\"\n        }\n      ],\n      \"name\": \"CallExecuted\",\n      \"type\": \"event\"\n    },\n    {\n      \"anonymous\": false,\n      \"inputs\": [\n        {\n          \"indexed\": true,\n          \"internalType\": \"bytes32\",\n          \"name\": \"id\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"uint256\",\n          \"name\": \"index\",\n          \"type\": \"uint256\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"address\",\n          \"name\": \"target\",\n          \"type\": \"address\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"uint256\",\n          \"name\": \"value\",\n          \"type\": \"uint256\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"bytes\",\n          \"name\": \"data\",\n          \"type\": \"bytes\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"bytes32\",\n          \"name\": \"predecessor\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"uint256\",\n          \"name\": \"delay\",\n          \"type\": \"uint256\"\n        }\n      ],\n      \"name\": \"CallScheduled\",\n      \"type\": \"event\"\n    },\n    {\n      \"anonymous\": false,\n      \"inputs\": [\n        {\n          \"indexed\": true,\n          \"internalType\": \"bytes32\",\n          \"name\": \"id\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"Cancelled\",\n      \"type\": \"event\"\n    },\n    {\n      \"anonymous\": false,\n      \"inputs\": [\n        {\n          \"indexed\": false,\n          \"internalType\": \"uint256\",\n          \"name\": \"oldDuration\",\n          \"type\": \"uint256\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"uint256\",\n          \"name\": \"newDuration\",\n          \"type\": \"uint256\"\n        }\n      ],\n      \"name\": \"MinDelayChange\",\n      \"type\": \"event\"\n    },\n    {\n      \"anonymous\": false,\n      \"inputs\": [\n        {\n          \"indexed\": true,\n          \"internalType\": \"bytes32\",\n          \"name\": \"role\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"bytes32\",\n          \"name\": \"previousAdminRole\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"bytes32\",\n          \"name\": \"newAdminRole\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"RoleAdminChanged\",\n      \"type\": \"event\"\n    },\n    {\n      \"anonymous\": false,\n      \"inputs\": [\n        {\n          \"indexed\": true,\n          \"internalType\": \"bytes32\",\n          \"name\": \"role\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"address\",\n          \"name\": \"account\",\n          \"type\": \"address\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"address\",\n          \"name\": \"sender\",\n          \"type\": \"address\"\n        }\n      ],\n      \"name\": \"RoleGranted\",\n      \"type\": \"event\"\n    },\n    {\n      \"anonymous\": false,\n      \"inputs\": [\n        {\n          \"indexed\": true,\n          \"internalType\": \"bytes32\",\n          \"name\": \"role\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"address\",\n          \"name\": \"account\",\n          \"type\": \"address\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"address\",\n          \"name\": \"sender\",\n          \"type\": \"address\"\n        }\n      ],\n      \"name\": \"RoleRevoked\",\n      \"type\": \"event\"\n    },\n    {\n      \"inputs\": [],\n      \"name\": \"DEFAULT_ADMIN_ROLE\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [],\n      \"name\": \"EXECUTOR_ROLE\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [],\n      \"name\": \"PROPOSER_ROLE\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [],\n      \"name\": \"TIMELOCK_ADMIN_ROLE\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"id\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"cancel\",\n      \"outputs\": [],\n      \"stateMutability\": \"nonpayable\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"address\",\n          \"name\": \"target\",\n          \"type\": \"address\"\n        },\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"value\",\n          \"type\": \"uint256\"\n        },\n        {\n          \"internalType\": \"bytes\",\n          \"name\": \"data\",\n          \"type\": \"bytes\"\n        },\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"predecessor\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"salt\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"execute\",\n      \"outputs\": [],\n      \"stateMutability\": \"payable\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"address[]\",\n          \"name\": \"targets\",\n          \"type\": \"address[]\"\n        },\n        {\n          \"internalType\": \"uint256[]\",\n          \"name\": \"values\",\n          \"type\": \"uint256[]\"\n        },\n        {\n          \"internalType\": \"bytes[]\",\n          \"name\": \"datas\",\n          \"type\": \"bytes[]\"\n        },\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"predecessor\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"salt\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"executeBatch\",\n      \"outputs\": [],\n      \"stateMutability\": \"payable\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [],\n      \"name\": \"getMinDelay\",\n      \"outputs\": [\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"duration\",\n          \"type\": \"uint256\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"role\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"getRoleAdmin\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"id\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"getTimestamp\",\n      \"outputs\": [\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"timestamp\",\n          \"type\": \"uint256\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"role\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"internalType\": \"address\",\n          \"name\": \"account\",\n          \"type\": \"address\"\n        }\n      ],\n      \"name\": \"grantRole\",\n      \"outputs\": [],\n      \"stateMutability\": \"nonpayable\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"role\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"internalType\": \"address\",\n          \"name\": \"account\",\n          \"type\": \"address\"\n        }\n      ],\n      \"name\": \"hasRole\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bool\",\n          \"name\": \"\",\n          \"type\": \"bool\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"address\",\n          \"name\": \"target\",\n          \"type\": \"address\"\n        },\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"value\",\n          \"type\": \"uint256\"\n        },\n        {\n          \"internalType\": \"bytes\",\n          \"name\": \"data\",\n          \"type\": \"bytes\"\n        },\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"predecessor\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"salt\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"hashOperation\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"hash\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"stateMutability\": \"pure\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"address[]\",\n          \"name\": \"targets\",\n          \"type\": \"address[]\"\n        },\n        {\n          \"internalType\": \"uint256[]\",\n          \"name\": \"values\",\n          \"type\": \"uint256[]\"\n        },\n        {\n          \"internalType\": \"bytes[]\",\n          \"name\": \"datas\",\n          \"type\": \"bytes[]\"\n        },\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"predecessor\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"salt\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"hashOperationBatch\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"hash\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"stateMutability\": \"pure\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"id\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"isOperation\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bool\",\n          \"name\": \"pending\",\n          \"type\": \"bool\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"id\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"isOperationDone\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bool\",\n          \"name\": \"done\",\n          \"type\": \"bool\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"id\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"isOperationPending\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bool\",\n          \"name\": \"pending\",\n          \"type\": \"bool\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"id\",\n          \"type\": \"bytes32\"\n        }\n      ],\n      \"name\": \"isOperationReady\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bool\",\n          \"name\": \"ready\",\n          \"type\": \"bool\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"role\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"internalType\": \"address\",\n          \"name\": \"account\",\n          \"type\": \"address\"\n        }\n      ],\n      \"name\": \"renounceRole\",\n      \"outputs\": [],\n      \"stateMutability\": \"nonpayable\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"role\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"internalType\": \"address\",\n          \"name\": \"account\",\n          \"type\": \"address\"\n        }\n      ],\n      \"name\": \"revokeRole\",\n      \"outputs\": [],\n      \"stateMutability\": \"nonpayable\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"address\",\n          \"name\": \"target\",\n          \"type\": \"address\"\n        },\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"value\",\n          \"type\": \"uint256\"\n        },\n        {\n          \"internalType\": \"bytes\",\n          \"name\": \"data\",\n          \"type\": \"bytes\"\n        },\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"predecessor\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"salt\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"delay\",\n          \"type\": \"uint256\"\n        }\n      ],\n      \"name\": \"schedule\",\n      \"outputs\": [],\n      \"stateMutability\": \"nonpayable\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"address[]\",\n          \"name\": \"targets\",\n          \"type\": \"address[]\"\n        },\n        {\n          \"internalType\": \"uint256[]\",\n          \"name\": \"values\",\n          \"type\": \"uint256[]\"\n        },\n        {\n          \"internalType\": \"bytes[]\",\n          \"name\": \"datas\",\n          \"type\": \"bytes[]\"\n        },\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"predecessor\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"internalType\": \"bytes32\",\n          \"name\": \"salt\",\n          \"type\": \"bytes32\"\n        },\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"delay\",\n          \"type\": \"uint256\"\n        }\n      ],\n      \"name\": \"scheduleBatch\",\n      \"outputs\": [],\n      \"stateMutability\": \"nonpayable\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes4\",\n          \"name\": \"interfaceId\",\n          \"type\": \"bytes4\"\n        }\n      ],\n      \"name\": \"supportsInterface\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bool\",\n          \"name\": \"\",\n          \"type\": \"bool\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"newDelay\",\n          \"type\": \"uint256\"\n        }\n      ],\n      \"name\": \"updateDelay\",\n      \"outputs\": [],\n      \"stateMutability\": \"nonpayable\",\n      \"type\": \"function\"\n    },\n    {\n      \"stateMutability\": \"payable\",\n      \"type\": \"receive\"\n    }\n  ],\n  \"bytecode\": \"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\",\n  \"deployedBytecode\": \"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\",\n  \"linkReferences\": {},\n  \"deployedLinkReferences\": {}\n}\n") . expect ("valid artifact JSON") ;
          artifact
        };
      }
      &ARTIFACT
    }
    #[doc = r" Creates a new contract instance with the specified `web3`"]
    #[doc = r" provider at the given `Address`."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a maching"]
    #[doc = r" `Abi` is actually deployed at the given address."]
    pub fn at<F, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + Unpin
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F> + Send + Sync + 'static,
    {
      Contract::with_deployment_info(web3, address, None)
    }
    #[doc = r" Creates a new contract instance with the specified `web3` provider with"]
    #[doc = r" the given `Abi` at the given `Address` and an optional transaction hash."]
    #[doc = r" This hash is used to retrieve contract related information such as the"]
    #[doc = r" creation block (which is useful for fetching all historic events)."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching `Abi` is"]
    #[doc = r" actually deployed at the given address nor that the transaction hash,"]
    #[doc = r" when provided, is actually for this contract deployment."]
    pub fn with_deployment_info<F, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
      deployment_information: Option<ethcontract::common::DeploymentInformation>,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + Unpin
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F> + Send + Sync + 'static,
    {
      use self::ethcontract::transport::DynTransport;
      use self::ethcontract::web3::api::Web3;
      use self::ethcontract::Instance;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let abi = Self::artifact().abi.clone();
      let instance = Instance::with_deployment_info(web3, abi, address, deployment_information);
      Contract::from_raw(instance)
    }
    #[doc = r" Creates a contract from a raw instance."]
    fn from_raw(instance: self::ethcontract::dyns::DynInstance) -> Self {
      let methods = Methods { instance };
      Contract { methods }
    }
    #[doc = r" Returns the contract address being used by this instance."]
    pub fn address(&self) -> self::ethcontract::Address {
      self.raw_instance().address()
    }
    #[doc = r" Returns the deployment information of the contract"]
    #[doc = r" if it is known, `None` otherwise."]
    pub fn deployment_information(&self) -> Option<ethcontract::common::DeploymentInformation> {
      self.raw_instance().deployment_information()
    }
    #[doc = r" Returns a reference to the default method options used by this"]
    #[doc = r" contract."]
    pub fn defaults(&self) -> &self::ethcontract::contract::MethodDefaults {
      &self.raw_instance().defaults
    }
    #[doc = r" Returns a mutable reference to the default method options used"]
    #[doc = r" by this contract."]
    pub fn defaults_mut(&mut self) -> &mut self::ethcontract::contract::MethodDefaults {
      &mut self.raw_instance_mut().defaults
    }
    #[doc = r" Returns a reference to the raw runtime instance used by this"]
    #[doc = r" contract."]
    pub fn raw_instance(&self) -> &self::ethcontract::dyns::DynInstance {
      &self.methods.instance
    }
    #[doc = r" Returns a mutable reference to the raw runtime instance used by"]
    #[doc = r" this contract."]
    fn raw_instance_mut(&mut self) -> &mut self::ethcontract::dyns::DynInstance {
      &mut self.methods.instance
    }
  }
  impl std::fmt::Debug for Contract {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
      f.debug_tuple(stringify!(TimelockController))
        .field(&self.address())
        .finish()
    }
  }
  impl Contract {
    #[doc = "Generated by `ethcontract`"]
    pub fn builder<F, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      min_delay: self::ethcontract::U256,
      proposers: Vec<self::ethcontract::Address>,
      executors: Vec<self::ethcontract::Address>,
    ) -> self::ethcontract::dyns::DynDeployBuilder<Self>
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + Unpin
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F> + Send + Sync + 'static,
    {
      use self::ethcontract::contract::DeployBuilder;
      use self::ethcontract::dyns::DynTransport;
      use self::ethcontract::web3::api::Web3;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let bytecode = Self::artifact().bytecode.clone();
      DeployBuilder::new(web3, bytecode, (min_delay, proposers, executors))
        .expect("valid deployment args")
    }
  }
  impl self::ethcontract::contract::Deploy<self::ethcontract::dyns::DynTransport> for Contract {
    type Context = self::ethcontract::common::Bytecode;
    fn bytecode(cx: &Self::Context) -> &self::ethcontract::common::Bytecode {
      cx
    }
    fn abi(_: &Self::Context) -> &self::ethcontract::common::Abi {
      &Self::artifact().abi
    }
    fn from_deployment(
      web3: self::ethcontract::dyns::DynWeb3,
      address: self::ethcontract::Address,
      transaction_hash: self::ethcontract::H256,
      _: Self::Context,
    ) -> Self {
      Self::with_deployment_info(&web3, address, Some(transaction_hash.into()))
    }
  }
  impl Contract {
    #[doc = r" Retrives a reference to type containing all the generated"]
    #[doc = r" contract methods. This can be used for methods where the name"]
    #[doc = r" would collide with a common method (like `at` or `deployed`)."]
    pub fn methods(&self) -> &Methods {
      &self.methods
    }
  }
  #[doc = r" Type containing all contract methods for generated contract type."]
  #[derive(Clone)]
  pub struct Methods {
    instance: self::ethcontract::dyns::DynInstance,
  }
  #[allow(clippy::too_many_arguments, clippy::type_complexity)]
  impl Methods {
    #[doc = "Generated by `ethcontract`"]
    pub fn proposer_role(&self) -> self::ethcontract::dyns::DynMethodBuilder<[u8; 32]> {
      self
        .instance
        .method([143, 97, 244, 245], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn schedule_batch(
      &self,
      targets: Vec<self::ethcontract::Address>,
      values: Vec<self::ethcontract::U256>,
      datas: Vec<Vec<u8>>,
      predecessor: [u8; 32],
      salt: [u8; 32],
      delay: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void> {
      self
        .instance
        .method(
          [143, 42, 11, 176],
          (targets, values, datas, predecessor, salt, delay),
        )
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn supports_interface(
      &self,
      interface_id: [u8; 4],
    ) -> self::ethcontract::dyns::DynMethodBuilder<bool> {
      self
        .instance
        .method([1, 255, 201, 167], (interface_id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn executor_role(&self) -> self::ethcontract::dyns::DynMethodBuilder<[u8; 32]> {
      self
        .instance
        .method([7, 189, 2, 101], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_role_admin(
      &self,
      role: [u8; 32],
    ) -> self::ethcontract::dyns::DynMethodBuilder<[u8; 32]> {
      self
        .instance
        .method([36, 138, 156, 163], (role,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn renounce_role(
      &self,
      role: [u8; 32],
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void> {
      self
        .instance
        .method([54, 86, 138, 190], (role, account))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn execute(
      &self,
      target: self::ethcontract::Address,
      value: self::ethcontract::U256,
      data: Vec<u8>,
      predecessor: [u8; 32],
      salt: [u8; 32],
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void> {
      self
        .instance
        .method([19, 64, 8, 211], (target, value, data, predecessor, salt))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn has_role(
      &self,
      role: [u8; 32],
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<bool> {
      self
        .instance
        .method([145, 209, 72, 84], (role, account))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn hash_operation(
      &self,
      target: self::ethcontract::Address,
      value: self::ethcontract::U256,
      data: Vec<u8>,
      predecessor: [u8; 32],
      salt: [u8; 32],
    ) -> self::ethcontract::dyns::DynMethodBuilder<[u8; 32]> {
      self
        .instance
        .method(
          [128, 101, 101, 127],
          (target, value, data, predecessor, salt),
        )
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn is_operation(&self, id: [u8; 32]) -> self::ethcontract::dyns::DynMethodBuilder<bool> {
      self
        .instance
        .method([49, 213, 7, 80], (id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn is_operation_ready(
      &self,
      id: [u8; 32],
    ) -> self::ethcontract::dyns::DynMethodBuilder<bool> {
      self
        .instance
        .method([19, 188, 159, 32], (id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn update_delay(
      &self,
      new_delay: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void> {
      self
        .instance
        .method([100, 214, 35, 83], (new_delay,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn cancel(
      &self,
      id: [u8; 32],
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void> {
      self
        .instance
        .method([196, 210, 82, 245], (id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn is_operation_done(
      &self,
      id: [u8; 32],
    ) -> self::ethcontract::dyns::DynMethodBuilder<bool> {
      self
        .instance
        .method([42, 176, 245, 41], (id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn grant_role(
      &self,
      role: [u8; 32],
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void> {
      self
        .instance
        .method([47, 47, 241, 93], (role, account))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_min_delay(
      &self,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .method([242, 122, 12, 146], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn revoke_role(
      &self,
      role: [u8; 32],
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void> {
      self
        .instance
        .method([213, 71, 116, 31], (role, account))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn timelock_admin_role(&self) -> self::ethcontract::dyns::DynMethodBuilder<[u8; 32]> {
      self
        .instance
        .method([13, 60, 246, 252], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn schedule(
      &self,
      target: self::ethcontract::Address,
      value: self::ethcontract::U256,
      data: Vec<u8>,
      predecessor: [u8; 32],
      salt: [u8; 32],
      delay: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void> {
      self
        .instance
        .method(
          [1, 213, 6, 42],
          (target, value, data, predecessor, salt, delay),
        )
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_timestamp(
      &self,
      id: [u8; 32],
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .method([212, 92, 68, 53], (id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn execute_batch(
      &self,
      targets: Vec<self::ethcontract::Address>,
      values: Vec<self::ethcontract::U256>,
      datas: Vec<Vec<u8>>,
      predecessor: [u8; 32],
      salt: [u8; 32],
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void> {
      self
        .instance
        .method(
          [227, 131, 53, 229],
          (targets, values, datas, predecessor, salt),
        )
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn default_admin_role(&self) -> self::ethcontract::dyns::DynMethodBuilder<[u8; 32]> {
      self
        .instance
        .method([162, 23, 253, 223], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn is_operation_pending(
      &self,
      id: [u8; 32],
    ) -> self::ethcontract::dyns::DynMethodBuilder<bool> {
      self
        .instance
        .method([88, 75, 21, 62], (id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn hash_operation_batch(
      &self,
      targets: Vec<self::ethcontract::Address>,
      values: Vec<self::ethcontract::U256>,
      datas: Vec<Vec<u8>>,
      predecessor: [u8; 32],
      salt: [u8; 32],
    ) -> self::ethcontract::dyns::DynMethodBuilder<[u8; 32]> {
      self
        .instance
        .method(
          [177, 197, 244, 39],
          (targets, values, datas, predecessor, salt),
        )
        .expect("generated call")
    }
  }
  impl std::ops::Deref for Contract {
    type Target = Methods;
    fn deref(&self) -> &Self::Target {
      &self.methods
    }
  }
  impl Contract {
    #[doc = r" Returns a method builder to setup a call to a smart"]
    #[doc = r" contract's fallback function."]
    pub fn fallback<D>(
      &self,
      data: D,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void>
    where
      D: Into<Vec<u8>>,
    {
      self
        .raw_instance()
        .fallback(data)
        .expect("generated fallback method")
    }
  }
  #[doc = r" Module containing all generated data models for this contract's"]
  #[doc = r" events."]
  pub mod event_data {
    use super::ethcontract;
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Cancelled {
      pub id: [u8; 32],
    }
    impl Cancelled {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          186, 161, 235, 34, 242, 164, 146, 186, 26, 95, 234, 97, 184, 223, 77, 39, 198, 200, 181,
          243, 151, 30, 99, 187, 88, 250, 20, 255, 114, 238, 219, 112,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Cancelled(bytes32)`"]
      pub fn abi_signature() -> &'static str {
        "Cancelled(bytes32)"
      }
    }
    impl self::ethcontract::web3::contract::tokens::Detokenize for Cancelled {
      fn from_tokens(
        tokens: Vec<self::ethcontract::common::abi::Token>,
      ) -> Result<Self, self::ethcontract::web3::contract::Error> {
        if tokens.len() != 1 {
          return Err(self::ethcontract::web3::contract::Error::InvalidOutputType(
            format!("Expected {} tokens, got {}: {:?}", 1, tokens.len(), tokens),
          ));
        }
        #[allow(unused_mut)]
        let mut tokens = tokens.into_iter();
        let id = <[u8; 32] as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
          tokens.next().unwrap(),
        )?;
        Ok(Cancelled { id })
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct RoleAdminChanged {
      pub role: [u8; 32],
      pub previous_admin_role: [u8; 32],
      pub new_admin_role: [u8; 32],
    }
    impl RoleAdminChanged {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          189, 121, 184, 111, 254, 10, 184, 232, 119, 97, 81, 81, 66, 23, 205, 124, 172, 213, 44,
          144, 159, 102, 71, 92, 58, 244, 78, 18, 159, 11, 0, 255,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`RoleAdminChanged(bytes32,bytes32,bytes32)`"]
      pub fn abi_signature() -> &'static str {
        "RoleAdminChanged(bytes32,bytes32,bytes32)"
      }
    }
    impl self::ethcontract::web3::contract::tokens::Detokenize for RoleAdminChanged {
      fn from_tokens(
        tokens: Vec<self::ethcontract::common::abi::Token>,
      ) -> Result<Self, self::ethcontract::web3::contract::Error> {
        if tokens.len() != 3 {
          return Err(self::ethcontract::web3::contract::Error::InvalidOutputType(
            format!("Expected {} tokens, got {}: {:?}", 3, tokens.len(), tokens),
          ));
        }
        #[allow(unused_mut)]
        let mut tokens = tokens.into_iter();
        let role =
          <[u8; 32] as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
            tokens.next().unwrap(),
          )?;
        let previous_admin_role =
          <[u8; 32] as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
            tokens.next().unwrap(),
          )?;
        let new_admin_role =
          <[u8; 32] as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
            tokens.next().unwrap(),
          )?;
        Ok(RoleAdminChanged {
          role,
          previous_admin_role,
          new_admin_role,
        })
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct RoleRevoked {
      pub role: [u8; 32],
      pub account: self::ethcontract::Address,
      pub sender: self::ethcontract::Address,
    }
    impl RoleRevoked {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          246, 57, 31, 92, 50, 217, 198, 157, 42, 71, 234, 103, 11, 68, 41, 116, 181, 57, 53, 209,
          237, 199, 253, 100, 235, 33, 224, 71, 168, 57, 23, 27,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`RoleRevoked(bytes32,address,address)`"]
      pub fn abi_signature() -> &'static str {
        "RoleRevoked(bytes32,address,address)"
      }
    }
    impl self::ethcontract::web3::contract::tokens::Detokenize for RoleRevoked {
      fn from_tokens(
        tokens: Vec<self::ethcontract::common::abi::Token>,
      ) -> Result<Self, self::ethcontract::web3::contract::Error> {
        if tokens.len() != 3 {
          return Err(self::ethcontract::web3::contract::Error::InvalidOutputType(
            format!("Expected {} tokens, got {}: {:?}", 3, tokens.len(), tokens),
          ));
        }
        #[allow(unused_mut)]
        let mut tokens = tokens.into_iter();
        let role =
          <[u8; 32] as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
            tokens.next().unwrap(),
          )?;
        let account = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let sender = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        Ok(RoleRevoked {
          role,
          account,
          sender,
        })
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct RoleGranted {
      pub role: [u8; 32],
      pub account: self::ethcontract::Address,
      pub sender: self::ethcontract::Address,
    }
    impl RoleGranted {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          47, 135, 136, 17, 126, 126, 255, 29, 130, 233, 38, 236, 121, 73, 1, 209, 124, 120, 2, 74,
          80, 39, 9, 64, 48, 69, 64, 167, 51, 101, 111, 13,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`RoleGranted(bytes32,address,address)`"]
      pub fn abi_signature() -> &'static str {
        "RoleGranted(bytes32,address,address)"
      }
    }
    impl self::ethcontract::web3::contract::tokens::Detokenize for RoleGranted {
      fn from_tokens(
        tokens: Vec<self::ethcontract::common::abi::Token>,
      ) -> Result<Self, self::ethcontract::web3::contract::Error> {
        if tokens.len() != 3 {
          return Err(self::ethcontract::web3::contract::Error::InvalidOutputType(
            format!("Expected {} tokens, got {}: {:?}", 3, tokens.len(), tokens),
          ));
        }
        #[allow(unused_mut)]
        let mut tokens = tokens.into_iter();
        let role =
          <[u8; 32] as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
            tokens.next().unwrap(),
          )?;
        let account = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let sender = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        Ok(RoleGranted {
          role,
          account,
          sender,
        })
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct MinDelayChange {
      pub old_duration: self::ethcontract::U256,
      pub new_duration: self::ethcontract::U256,
    }
    impl MinDelayChange {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          17, 194, 79, 78, 173, 22, 80, 124, 105, 172, 70, 127, 189, 94, 78, 237, 95, 181, 198,
          153, 98, 109, 44, 198, 214, 100, 33, 223, 37, 56, 134, 213,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`MinDelayChange(uint256,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "MinDelayChange(uint256,uint256)"
      }
    }
    impl self::ethcontract::web3::contract::tokens::Detokenize for MinDelayChange {
      fn from_tokens(
        tokens: Vec<self::ethcontract::common::abi::Token>,
      ) -> Result<Self, self::ethcontract::web3::contract::Error> {
        if tokens.len() != 2 {
          return Err(self::ethcontract::web3::contract::Error::InvalidOutputType(
            format!("Expected {} tokens, got {}: {:?}", 2, tokens.len(), tokens),
          ));
        }
        #[allow(unused_mut)]
        let mut tokens = tokens.into_iter();
        let old_duration = < self :: ethcontract :: U256 as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let new_duration = < self :: ethcontract :: U256 as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        Ok(MinDelayChange {
          old_duration,
          new_duration,
        })
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct CallExecuted {
      pub id: [u8; 32],
      pub index: self::ethcontract::U256,
      pub target: self::ethcontract::Address,
      pub value: self::ethcontract::U256,
      pub data: Vec<u8>,
    }
    impl CallExecuted {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          194, 97, 126, 250, 105, 186, 182, 103, 130, 250, 33, 149, 67, 113, 67, 56, 72, 156, 78,
          158, 23, 130, 113, 86, 10, 145, 184, 44, 63, 97, 43, 88,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`CallExecuted(bytes32,uint256,address,uint256,bytes)`"]
      pub fn abi_signature() -> &'static str {
        "CallExecuted(bytes32,uint256,address,uint256,bytes)"
      }
    }
    impl self::ethcontract::web3::contract::tokens::Detokenize for CallExecuted {
      fn from_tokens(
        tokens: Vec<self::ethcontract::common::abi::Token>,
      ) -> Result<Self, self::ethcontract::web3::contract::Error> {
        if tokens.len() != 5 {
          return Err(self::ethcontract::web3::contract::Error::InvalidOutputType(
            format!("Expected {} tokens, got {}: {:?}", 5, tokens.len(), tokens),
          ));
        }
        #[allow(unused_mut)]
        let mut tokens = tokens.into_iter();
        let id = <[u8; 32] as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
          tokens.next().unwrap(),
        )?;
        let index = < self :: ethcontract :: U256 as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let target = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let value = < self :: ethcontract :: U256 as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let data = <Vec<u8> as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
          tokens.next().unwrap(),
        )?;
        Ok(CallExecuted {
          id,
          index,
          target,
          value,
          data,
        })
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct CallScheduled {
      pub id: [u8; 32],
      pub index: self::ethcontract::U256,
      pub target: self::ethcontract::Address,
      pub value: self::ethcontract::U256,
      pub data: Vec<u8>,
      pub predecessor: [u8; 32],
      pub delay: self::ethcontract::U256,
    }
    impl CallScheduled {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          76, 244, 65, 12, 197, 112, 64, 228, 72, 98, 239, 15, 69, 243, 221, 90, 94, 2, 219, 142,
          184, 173, 214, 72, 212, 176, 226, 54, 241, 208, 125, 202,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`CallScheduled(bytes32,uint256,address,uint256,bytes,bytes32,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "CallScheduled(bytes32,uint256,address,uint256,bytes,bytes32,uint256)"
      }
    }
    impl self::ethcontract::web3::contract::tokens::Detokenize for CallScheduled {
      fn from_tokens(
        tokens: Vec<self::ethcontract::common::abi::Token>,
      ) -> Result<Self, self::ethcontract::web3::contract::Error> {
        if tokens.len() != 7 {
          return Err(self::ethcontract::web3::contract::Error::InvalidOutputType(
            format!("Expected {} tokens, got {}: {:?}", 7, tokens.len(), tokens),
          ));
        }
        #[allow(unused_mut)]
        let mut tokens = tokens.into_iter();
        let id = <[u8; 32] as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
          tokens.next().unwrap(),
        )?;
        let index = < self :: ethcontract :: U256 as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let target = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let value = < self :: ethcontract :: U256 as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let data = <Vec<u8> as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
          tokens.next().unwrap(),
        )?;
        let predecessor =
          <[u8; 32] as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
            tokens.next().unwrap(),
          )?;
        let delay = < self :: ethcontract :: U256 as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        Ok(CallScheduled {
          id,
          index,
          target,
          value,
          data,
          predecessor,
          delay,
        })
      }
    }
  }
  impl Contract {
    #[doc = r" Retrieves a handle to a type containing for creating event"]
    #[doc = r" streams for all the contract events."]
    pub fn events(&self) -> Events<'_> {
      Events {
        instance: self.raw_instance(),
      }
    }
  }
  pub struct Events<'a> {
    instance: &'a self::ethcontract::dyns::DynInstance,
  }
  impl Events<'_> {
    #[doc = r" Generated by `ethcontract`."]
    pub fn cancelled(&self) -> self::event_builders::CancelledBuilder {
      self::event_builders::CancelledBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            186, 161, 235, 34, 242, 164, 146, 186, 26, 95, 234, 97, 184, 223, 77, 39, 198, 200,
            181, 243, 151, 30, 99, 187, 88, 250, 20, 255, 114, 238, 219, 112,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn role_admin_changed(&self) -> self::event_builders::RoleAdminChangedBuilder {
      self::event_builders::RoleAdminChangedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            189, 121, 184, 111, 254, 10, 184, 232, 119, 97, 81, 81, 66, 23, 205, 124, 172, 213, 44,
            144, 159, 102, 71, 92, 58, 244, 78, 18, 159, 11, 0, 255,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn role_revoked(&self) -> self::event_builders::RoleRevokedBuilder {
      self::event_builders::RoleRevokedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            246, 57, 31, 92, 50, 217, 198, 157, 42, 71, 234, 103, 11, 68, 41, 116, 181, 57, 53,
            209, 237, 199, 253, 100, 235, 33, 224, 71, 168, 57, 23, 27,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn role_granted(&self) -> self::event_builders::RoleGrantedBuilder {
      self::event_builders::RoleGrantedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            47, 135, 136, 17, 126, 126, 255, 29, 130, 233, 38, 236, 121, 73, 1, 209, 124, 120, 2,
            74, 80, 39, 9, 64, 48, 69, 64, 167, 51, 101, 111, 13,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn min_delay_change(&self) -> self::event_builders::MinDelayChangeBuilder {
      self::event_builders::MinDelayChangeBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            17, 194, 79, 78, 173, 22, 80, 124, 105, 172, 70, 127, 189, 94, 78, 237, 95, 181, 198,
            153, 98, 109, 44, 198, 214, 100, 33, 223, 37, 56, 134, 213,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn call_executed(&self) -> self::event_builders::CallExecutedBuilder {
      self::event_builders::CallExecutedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            194, 97, 126, 250, 105, 186, 182, 103, 130, 250, 33, 149, 67, 113, 67, 56, 72, 156, 78,
            158, 23, 130, 113, 86, 10, 145, 184, 44, 63, 97, 43, 88,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn call_scheduled(&self) -> self::event_builders::CallScheduledBuilder {
      self::event_builders::CallScheduledBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            76, 244, 65, 12, 197, 112, 64, 228, 72, 98, 239, 15, 69, 243, 221, 90, 94, 2, 219, 142,
            184, 173, 214, 72, 212, 176, 226, 54, 241, 208, 125, 202,
          ]))
          .expect("generated event filter"),
      )
    }
  }
  #[doc = r" Module containing the generated event stream builders with type safe"]
  #[doc = r" filter methods for this contract's events."]
  pub mod event_builders {
    use super::ethcontract;
    use super::event_data;
    #[doc = "A builder for creating a filtered stream of `Cancelled` events."]
    pub struct CancelledBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Cancelled>,
    );
    impl CancelledBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limit the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" The polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the id event parameter."]
      pub fn id(mut self, topic: self::ethcontract::Topic<[u8; 32]>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Cancelled>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Cancelled>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `RoleAdminChanged` events."]
    pub struct RoleAdminChangedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::RoleAdminChanged>,
    );
    impl RoleAdminChangedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limit the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" The polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the role event parameter."]
      pub fn role(mut self, topic: self::ethcontract::Topic<[u8; 32]>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the previousAdminRole event parameter."]
      pub fn previous_admin_role(mut self, topic: self::ethcontract::Topic<[u8; 32]>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the newAdminRole event parameter."]
      pub fn new_admin_role(mut self, topic: self::ethcontract::Topic<[u8; 32]>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::RoleAdminChanged>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::RoleAdminChanged>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `RoleRevoked` events."]
    pub struct RoleRevokedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::RoleRevoked>,
    );
    impl RoleRevokedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limit the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" The polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the role event parameter."]
      pub fn role(mut self, topic: self::ethcontract::Topic<[u8; 32]>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the account event parameter."]
      pub fn account(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the sender event parameter."]
      pub fn sender(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::RoleRevoked>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::RoleRevoked>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `RoleGranted` events."]
    pub struct RoleGrantedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::RoleGranted>,
    );
    impl RoleGrantedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limit the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" The polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the role event parameter."]
      pub fn role(mut self, topic: self::ethcontract::Topic<[u8; 32]>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the account event parameter."]
      pub fn account(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the sender event parameter."]
      pub fn sender(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::RoleGranted>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::RoleGranted>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `MinDelayChange` events."]
    pub struct MinDelayChangeBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::MinDelayChange>,
    );
    impl MinDelayChangeBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limit the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" The polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::MinDelayChange>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::MinDelayChange>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `CallExecuted` events."]
    pub struct CallExecutedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::CallExecuted>,
    );
    impl CallExecutedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limit the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" The polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the id event parameter."]
      pub fn id(mut self, topic: self::ethcontract::Topic<[u8; 32]>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the index event parameter."]
      pub fn index(mut self, topic: self::ethcontract::Topic<self::ethcontract::U256>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::CallExecuted>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::CallExecuted>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `CallScheduled` events."]
    pub struct CallScheduledBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::CallScheduled>,
    );
    impl CallScheduledBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limit the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" The polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the id event parameter."]
      pub fn id(mut self, topic: self::ethcontract::Topic<[u8; 32]>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the index event parameter."]
      pub fn index(mut self, topic: self::ethcontract::Topic<self::ethcontract::U256>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::CallScheduled>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::CallScheduled>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
  }
  impl Contract {
    #[doc = r" Returns a log stream with all events."]
    pub fn all_events(&self) -> self::ethcontract::dyns::DynAllEventsBuilder<Event> {
      self::ethcontract::dyns::DynAllEventsBuilder::new(
        self.raw_instance().web3(),
        self.address(),
        self.deployment_information(),
      )
    }
  }
  #[doc = r" A contract event."]
  #[derive(Clone, Debug, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
  pub enum Event {
    CallExecuted(self::event_data::CallExecuted),
    CallScheduled(self::event_data::CallScheduled),
    Cancelled(self::event_data::Cancelled),
    MinDelayChange(self::event_data::MinDelayChange),
    RoleAdminChanged(self::event_data::RoleAdminChanged),
    RoleGranted(self::event_data::RoleGranted),
    RoleRevoked(self::event_data::RoleRevoked),
  }
  impl self::ethcontract::contract::ParseLog for Event {
    fn parse_log(
      log: self::ethcontract::RawLog,
    ) -> Result<Self, self::ethcontract::errors::ExecutionError> {
      let standard_event = log . topics . get (0) . copied () . map (| topic | match topic { self :: ethcontract :: H256 ([194 , 97 , 126 , 250 , 105 , 186 , 182 , 103 , 130 , 250 , 33 , 149 , 67 , 113 , 67 , 56 , 72 , 156 , 78 , 158 , 23 , 130 , 113 , 86 , 10 , 145 , 184 , 44 , 63 , 97 , 43 , 88]) => Ok (Event :: CallExecuted (log . clone () . decode (& Contract :: artifact () . abi . event ("CallExecuted") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([76 , 244 , 65 , 12 , 197 , 112 , 64 , 228 , 72 , 98 , 239 , 15 , 69 , 243 , 221 , 90 , 94 , 2 , 219 , 142 , 184 , 173 , 214 , 72 , 212 , 176 , 226 , 54 , 241 , 208 , 125 , 202]) => Ok (Event :: CallScheduled (log . clone () . decode (& Contract :: artifact () . abi . event ("CallScheduled") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([186 , 161 , 235 , 34 , 242 , 164 , 146 , 186 , 26 , 95 , 234 , 97 , 184 , 223 , 77 , 39 , 198 , 200 , 181 , 243 , 151 , 30 , 99 , 187 , 88 , 250 , 20 , 255 , 114 , 238 , 219 , 112]) => Ok (Event :: Cancelled (log . clone () . decode (& Contract :: artifact () . abi . event ("Cancelled") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([17 , 194 , 79 , 78 , 173 , 22 , 80 , 124 , 105 , 172 , 70 , 127 , 189 , 94 , 78 , 237 , 95 , 181 , 198 , 153 , 98 , 109 , 44 , 198 , 214 , 100 , 33 , 223 , 37 , 56 , 134 , 213]) => Ok (Event :: MinDelayChange (log . clone () . decode (& Contract :: artifact () . abi . event ("MinDelayChange") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([189 , 121 , 184 , 111 , 254 , 10 , 184 , 232 , 119 , 97 , 81 , 81 , 66 , 23 , 205 , 124 , 172 , 213 , 44 , 144 , 159 , 102 , 71 , 92 , 58 , 244 , 78 , 18 , 159 , 11 , 0 , 255]) => Ok (Event :: RoleAdminChanged (log . clone () . decode (& Contract :: artifact () . abi . event ("RoleAdminChanged") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([47 , 135 , 136 , 17 , 126 , 126 , 255 , 29 , 130 , 233 , 38 , 236 , 121 , 73 , 1 , 209 , 124 , 120 , 2 , 74 , 80 , 39 , 9 , 64 , 48 , 69 , 64 , 167 , 51 , 101 , 111 , 13]) => Ok (Event :: RoleGranted (log . clone () . decode (& Contract :: artifact () . abi . event ("RoleGranted") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([246 , 57 , 31 , 92 , 50 , 217 , 198 , 157 , 42 , 71 , 234 , 103 , 11 , 68 , 41 , 116 , 181 , 57 , 53 , 209 , 237 , 199 , 253 , 100 , 235 , 33 , 224 , 71 , 168 , 57 , 23 , 27]) => Ok (Event :: RoleRevoked (log . clone () . decode (& Contract :: artifact () . abi . event ("RoleRevoked") . expect ("generated event decode")) ?)) , _ => Err (self :: ethcontract :: errors :: ExecutionError :: from (self :: ethcontract :: common :: abi :: Error :: InvalidData)) , }) ;
      if let Some(Ok(data)) = standard_event {
        return Ok(data);
      }
      Err(self::ethcontract::errors::ExecutionError::from(
        self::ethcontract::common::abi::Error::InvalidData,
      ))
    }
  }
}
pub use self::timelock_controller::Contract as TimelockController;
