#[allow(dead_code)]
pub mod erc1155 {
  # [rustfmt :: skip] use ethcontract as ethcontract ;
  #[doc = "Generated by `ethcontract`"]
  #[derive(Clone)]
  pub struct Contract {
    methods: Methods,
  }
  impl Contract {
    #[doc = r" Retrieves the truffle artifact used to generate the type safe"]
    #[doc = r" API for this contract."]
    pub fn artifact() -> &'static self::ethcontract::Artifact {
      use self::ethcontract::private::lazy_static;
      use self::ethcontract::Artifact;
      lazy_static! {
        pub static ref ARTIFACT: Artifact = {
          # [allow (unused_mut)] let mut artifact = Artifact :: from_json ("{\n  \"_format\": \"hh-sol-artifact-1\",\n  \"contractName\": \"ERC1155\",\n  \"sourceName\": \"contracts/token/ERC1155/ERC1155.sol\",\n  \"abi\": [\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"string\",\n          \"name\": \"uri_\",\n          \"type\": \"string\"\n        }\n      ],\n      \"stateMutability\": \"nonpayable\",\n      \"type\": \"constructor\"\n    },\n    {\n      \"anonymous\": false,\n      \"inputs\": [\n        {\n          \"indexed\": true,\n          \"internalType\": \"address\",\n          \"name\": \"account\",\n          \"type\": \"address\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"address\",\n          \"name\": \"operator\",\n          \"type\": \"address\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"bool\",\n          \"name\": \"approved\",\n          \"type\": \"bool\"\n        }\n      ],\n      \"name\": \"ApprovalForAll\",\n      \"type\": \"event\"\n    },\n    {\n      \"anonymous\": false,\n      \"inputs\": [\n        {\n          \"indexed\": true,\n          \"internalType\": \"address\",\n          \"name\": \"operator\",\n          \"type\": \"address\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"address\",\n          \"name\": \"from\",\n          \"type\": \"address\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"address\",\n          \"name\": \"to\",\n          \"type\": \"address\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"uint256[]\",\n          \"name\": \"ids\",\n          \"type\": \"uint256[]\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"uint256[]\",\n          \"name\": \"values\",\n          \"type\": \"uint256[]\"\n        }\n      ],\n      \"name\": \"TransferBatch\",\n      \"type\": \"event\"\n    },\n    {\n      \"anonymous\": false,\n      \"inputs\": [\n        {\n          \"indexed\": true,\n          \"internalType\": \"address\",\n          \"name\": \"operator\",\n          \"type\": \"address\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"address\",\n          \"name\": \"from\",\n          \"type\": \"address\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"address\",\n          \"name\": \"to\",\n          \"type\": \"address\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"uint256\",\n          \"name\": \"id\",\n          \"type\": \"uint256\"\n        },\n        {\n          \"indexed\": false,\n          \"internalType\": \"uint256\",\n          \"name\": \"value\",\n          \"type\": \"uint256\"\n        }\n      ],\n      \"name\": \"TransferSingle\",\n      \"type\": \"event\"\n    },\n    {\n      \"anonymous\": false,\n      \"inputs\": [\n        {\n          \"indexed\": false,\n          \"internalType\": \"string\",\n          \"name\": \"value\",\n          \"type\": \"string\"\n        },\n        {\n          \"indexed\": true,\n          \"internalType\": \"uint256\",\n          \"name\": \"id\",\n          \"type\": \"uint256\"\n        }\n      ],\n      \"name\": \"URI\",\n      \"type\": \"event\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"address\",\n          \"name\": \"account\",\n          \"type\": \"address\"\n        },\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"id\",\n          \"type\": \"uint256\"\n        }\n      ],\n      \"name\": \"balanceOf\",\n      \"outputs\": [\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"\",\n          \"type\": \"uint256\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"address[]\",\n          \"name\": \"accounts\",\n          \"type\": \"address[]\"\n        },\n        {\n          \"internalType\": \"uint256[]\",\n          \"name\": \"ids\",\n          \"type\": \"uint256[]\"\n        }\n      ],\n      \"name\": \"balanceOfBatch\",\n      \"outputs\": [\n        {\n          \"internalType\": \"uint256[]\",\n          \"name\": \"\",\n          \"type\": \"uint256[]\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"address\",\n          \"name\": \"account\",\n          \"type\": \"address\"\n        },\n        {\n          \"internalType\": \"address\",\n          \"name\": \"operator\",\n          \"type\": \"address\"\n        }\n      ],\n      \"name\": \"isApprovedForAll\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bool\",\n          \"name\": \"\",\n          \"type\": \"bool\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"address\",\n          \"name\": \"from\",\n          \"type\": \"address\"\n        },\n        {\n          \"internalType\": \"address\",\n          \"name\": \"to\",\n          \"type\": \"address\"\n        },\n        {\n          \"internalType\": \"uint256[]\",\n          \"name\": \"ids\",\n          \"type\": \"uint256[]\"\n        },\n        {\n          \"internalType\": \"uint256[]\",\n          \"name\": \"amounts\",\n          \"type\": \"uint256[]\"\n        },\n        {\n          \"internalType\": \"bytes\",\n          \"name\": \"data\",\n          \"type\": \"bytes\"\n        }\n      ],\n      \"name\": \"safeBatchTransferFrom\",\n      \"outputs\": [],\n      \"stateMutability\": \"nonpayable\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"address\",\n          \"name\": \"from\",\n          \"type\": \"address\"\n        },\n        {\n          \"internalType\": \"address\",\n          \"name\": \"to\",\n          \"type\": \"address\"\n        },\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"id\",\n          \"type\": \"uint256\"\n        },\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"amount\",\n          \"type\": \"uint256\"\n        },\n        {\n          \"internalType\": \"bytes\",\n          \"name\": \"data\",\n          \"type\": \"bytes\"\n        }\n      ],\n      \"name\": \"safeTransferFrom\",\n      \"outputs\": [],\n      \"stateMutability\": \"nonpayable\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"address\",\n          \"name\": \"operator\",\n          \"type\": \"address\"\n        },\n        {\n          \"internalType\": \"bool\",\n          \"name\": \"approved\",\n          \"type\": \"bool\"\n        }\n      ],\n      \"name\": \"setApprovalForAll\",\n      \"outputs\": [],\n      \"stateMutability\": \"nonpayable\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"bytes4\",\n          \"name\": \"interfaceId\",\n          \"type\": \"bytes4\"\n        }\n      ],\n      \"name\": \"supportsInterface\",\n      \"outputs\": [\n        {\n          \"internalType\": \"bool\",\n          \"name\": \"\",\n          \"type\": \"bool\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    },\n    {\n      \"inputs\": [\n        {\n          \"internalType\": \"uint256\",\n          \"name\": \"\",\n          \"type\": \"uint256\"\n        }\n      ],\n      \"name\": \"uri\",\n      \"outputs\": [\n        {\n          \"internalType\": \"string\",\n          \"name\": \"\",\n          \"type\": \"string\"\n        }\n      ],\n      \"stateMutability\": \"view\",\n      \"type\": \"function\"\n    }\n  ],\n  \"bytecode\": \"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\",\n  \"deployedBytecode\": \"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\",\n  \"linkReferences\": {},\n  \"deployedLinkReferences\": {}\n}\n") . expect ("valid artifact JSON") ;
          artifact
        };
      }
      &ARTIFACT
    }
    #[doc = r" Creates a new contract instance with the specified `web3`"]
    #[doc = r" provider at the given `Address`."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a maching"]
    #[doc = r" `Abi` is actually deployed at the given address."]
    pub fn at<F, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + Unpin
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F> + Send + Sync + 'static,
    {
      Contract::with_deployment_info(web3, address, None)
    }
    #[doc = r" Creates a new contract instance with the specified `web3` provider with"]
    #[doc = r" the given `Abi` at the given `Address` and an optional transaction hash."]
    #[doc = r" This hash is used to retrieve contract related information such as the"]
    #[doc = r" creation block (which is useful for fetching all historic events)."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching `Abi` is"]
    #[doc = r" actually deployed at the given address nor that the transaction hash,"]
    #[doc = r" when provided, is actually for this contract deployment."]
    pub fn with_deployment_info<F, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
      deployment_information: Option<ethcontract::common::DeploymentInformation>,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + Unpin
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F> + Send + Sync + 'static,
    {
      use self::ethcontract::transport::DynTransport;
      use self::ethcontract::web3::api::Web3;
      use self::ethcontract::Instance;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let abi = Self::artifact().abi.clone();
      let instance = Instance::with_deployment_info(web3, abi, address, deployment_information);
      Contract::from_raw(instance)
    }
    #[doc = r" Creates a contract from a raw instance."]
    fn from_raw(instance: self::ethcontract::dyns::DynInstance) -> Self {
      let methods = Methods { instance };
      Contract { methods }
    }
    #[doc = r" Returns the contract address being used by this instance."]
    pub fn address(&self) -> self::ethcontract::Address {
      self.raw_instance().address()
    }
    #[doc = r" Returns the deployment information of the contract"]
    #[doc = r" if it is known, `None` otherwise."]
    pub fn deployment_information(&self) -> Option<ethcontract::common::DeploymentInformation> {
      self.raw_instance().deployment_information()
    }
    #[doc = r" Returns a reference to the default method options used by this"]
    #[doc = r" contract."]
    pub fn defaults(&self) -> &self::ethcontract::contract::MethodDefaults {
      &self.raw_instance().defaults
    }
    #[doc = r" Returns a mutable reference to the default method options used"]
    #[doc = r" by this contract."]
    pub fn defaults_mut(&mut self) -> &mut self::ethcontract::contract::MethodDefaults {
      &mut self.raw_instance_mut().defaults
    }
    #[doc = r" Returns a reference to the raw runtime instance used by this"]
    #[doc = r" contract."]
    pub fn raw_instance(&self) -> &self::ethcontract::dyns::DynInstance {
      &self.methods.instance
    }
    #[doc = r" Returns a mutable reference to the raw runtime instance used by"]
    #[doc = r" this contract."]
    fn raw_instance_mut(&mut self) -> &mut self::ethcontract::dyns::DynInstance {
      &mut self.methods.instance
    }
  }
  impl std::fmt::Debug for Contract {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
      f.debug_tuple(stringify!(ERC1155))
        .field(&self.address())
        .finish()
    }
  }
  impl Contract {
    #[doc = "Generated by `ethcontract`"]
    pub fn builder<F, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      uri: String,
    ) -> self::ethcontract::dyns::DynDeployBuilder<Self>
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + Unpin
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F> + Send + Sync + 'static,
    {
      use self::ethcontract::contract::DeployBuilder;
      use self::ethcontract::dyns::DynTransport;
      use self::ethcontract::web3::api::Web3;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let bytecode = Self::artifact().bytecode.clone();
      DeployBuilder::new(web3, bytecode, (uri,)).expect("valid deployment args")
    }
  }
  impl self::ethcontract::contract::Deploy<self::ethcontract::dyns::DynTransport> for Contract {
    type Context = self::ethcontract::common::Bytecode;
    fn bytecode(cx: &Self::Context) -> &self::ethcontract::common::Bytecode {
      cx
    }
    fn abi(_: &Self::Context) -> &self::ethcontract::common::Abi {
      &Self::artifact().abi
    }
    fn from_deployment(
      web3: self::ethcontract::dyns::DynWeb3,
      address: self::ethcontract::Address,
      transaction_hash: self::ethcontract::H256,
      _: Self::Context,
    ) -> Self {
      Self::with_deployment_info(&web3, address, Some(transaction_hash.into()))
    }
  }
  impl Contract {
    #[doc = r" Retrives a reference to type containing all the generated"]
    #[doc = r" contract methods. This can be used for methods where the name"]
    #[doc = r" would collide with a common method (like `at` or `deployed`)."]
    pub fn methods(&self) -> &Methods {
      &self.methods
    }
  }
  #[doc = r" Type containing all contract methods for generated contract type."]
  #[derive(Clone)]
  pub struct Methods {
    instance: self::ethcontract::dyns::DynInstance,
  }
  #[allow(clippy::too_many_arguments, clippy::type_complexity)]
  impl Methods {
    #[doc = "Generated by `ethcontract`"]
    pub fn supports_interface(
      &self,
      interface_id: [u8; 4],
    ) -> self::ethcontract::dyns::DynMethodBuilder<bool> {
      self
        .instance
        .method([1, 255, 201, 167], (interface_id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn balance_of_batch(
      &self,
      accounts: Vec<self::ethcontract::Address>,
      ids: Vec<self::ethcontract::U256>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<Vec<self::ethcontract::U256>> {
      self
        .instance
        .method([78, 18, 115, 244], (accounts, ids))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn balance_of(
      &self,
      account: self::ethcontract::Address,
      id: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .method([0, 253, 213, 142], (account, id))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn safe_transfer_from(
      &self,
      from: self::ethcontract::Address,
      to: self::ethcontract::Address,
      id: self::ethcontract::U256,
      amount: self::ethcontract::U256,
      data: Vec<u8>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void> {
      self
        .instance
        .method([242, 66, 67, 42], (from, to, id, amount, data))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn is_approved_for_all(
      &self,
      account: self::ethcontract::Address,
      operator: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<bool> {
      self
        .instance
        .method([233, 133, 233, 197], (account, operator))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn safe_batch_transfer_from(
      &self,
      from: self::ethcontract::Address,
      to: self::ethcontract::Address,
      ids: Vec<self::ethcontract::U256>,
      amounts: Vec<self::ethcontract::U256>,
      data: Vec<u8>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void> {
      self
        .instance
        .method([46, 178, 194, 214], (from, to, ids, amounts, data))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn set_approval_for_all(
      &self,
      operator: self::ethcontract::Address,
      approved: bool,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Void> {
      self
        .instance
        .method([162, 44, 180, 101], (operator, approved))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn uri(
      &self,
      p0: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<String> {
      self
        .instance
        .method([14, 137, 52, 28], (p0,))
        .expect("generated call")
    }
  }
  impl std::ops::Deref for Contract {
    type Target = Methods;
    fn deref(&self) -> &Self::Target {
      &self.methods
    }
  }
  #[doc = r" Module containing all generated data models for this contract's"]
  #[doc = r" events."]
  pub mod event_data {
    use super::ethcontract;
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct ApprovalForAll {
      pub account: self::ethcontract::Address,
      pub operator: self::ethcontract::Address,
      pub approved: bool,
    }
    impl ApprovalForAll {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          23, 48, 126, 171, 57, 171, 97, 7, 232, 137, 152, 69, 173, 61, 89, 189, 150, 83, 242, 0,
          242, 32, 146, 4, 137, 202, 43, 89, 55, 105, 108, 49,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`ApprovalForAll(address,address,bool)`"]
      pub fn abi_signature() -> &'static str {
        "ApprovalForAll(address,address,bool)"
      }
    }
    impl self::ethcontract::web3::contract::tokens::Detokenize for ApprovalForAll {
      fn from_tokens(
        tokens: Vec<self::ethcontract::common::abi::Token>,
      ) -> Result<Self, self::ethcontract::web3::contract::Error> {
        if tokens.len() != 3 {
          return Err(self::ethcontract::web3::contract::Error::InvalidOutputType(
            format!("Expected {} tokens, got {}: {:?}", 3, tokens.len(), tokens),
          ));
        }
        #[allow(unused_mut)]
        let mut tokens = tokens.into_iter();
        let account = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let operator = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let approved =
          <bool as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
            tokens.next().unwrap(),
          )?;
        Ok(ApprovalForAll {
          account,
          operator,
          approved,
        })
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct TransferBatch {
      pub operator: self::ethcontract::Address,
      pub from: self::ethcontract::Address,
      pub to: self::ethcontract::Address,
      pub ids: Vec<self::ethcontract::U256>,
      pub values: Vec<self::ethcontract::U256>,
    }
    impl TransferBatch {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          74, 57, 220, 6, 212, 192, 219, 198, 75, 112, 175, 144, 253, 105, 138, 35, 58, 81, 138,
          165, 208, 126, 89, 93, 152, 59, 140, 5, 38, 200, 247, 251,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`TransferBatch(address,address,address,uint256[],uint256[])`"]
      pub fn abi_signature() -> &'static str {
        "TransferBatch(address,address,address,uint256[],uint256[])"
      }
    }
    impl self::ethcontract::web3::contract::tokens::Detokenize for TransferBatch {
      fn from_tokens(
        tokens: Vec<self::ethcontract::common::abi::Token>,
      ) -> Result<Self, self::ethcontract::web3::contract::Error> {
        if tokens.len() != 5 {
          return Err(self::ethcontract::web3::contract::Error::InvalidOutputType(
            format!("Expected {} tokens, got {}: {:?}", 5, tokens.len(), tokens),
          ));
        }
        #[allow(unused_mut)]
        let mut tokens = tokens.into_iter();
        let operator = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let from = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let to = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let ids = < Vec < self :: ethcontract :: U256 > as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let values = < Vec < self :: ethcontract :: U256 > as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        Ok(TransferBatch {
          operator,
          from,
          to,
          ids,
          values,
        })
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct TransferSingle {
      pub operator: self::ethcontract::Address,
      pub from: self::ethcontract::Address,
      pub to: self::ethcontract::Address,
      pub id: self::ethcontract::U256,
      pub value: self::ethcontract::U256,
    }
    impl TransferSingle {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          195, 213, 129, 104, 197, 174, 115, 151, 115, 29, 6, 61, 91, 191, 61, 101, 120, 84, 66,
          115, 67, 244, 192, 131, 36, 15, 122, 172, 170, 45, 15, 98,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`TransferSingle(address,address,address,uint256,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "TransferSingle(address,address,address,uint256,uint256)"
      }
    }
    impl self::ethcontract::web3::contract::tokens::Detokenize for TransferSingle {
      fn from_tokens(
        tokens: Vec<self::ethcontract::common::abi::Token>,
      ) -> Result<Self, self::ethcontract::web3::contract::Error> {
        if tokens.len() != 5 {
          return Err(self::ethcontract::web3::contract::Error::InvalidOutputType(
            format!("Expected {} tokens, got {}: {:?}", 5, tokens.len(), tokens),
          ));
        }
        #[allow(unused_mut)]
        let mut tokens = tokens.into_iter();
        let operator = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let from = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let to = < self :: ethcontract :: Address as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let id = < self :: ethcontract :: U256 as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        let value = < self :: ethcontract :: U256 as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        Ok(TransferSingle {
          operator,
          from,
          to,
          id,
          value,
        })
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Uri {
      pub value: String,
      pub id: self::ethcontract::U256,
    }
    impl Uri {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          107, 183, 255, 112, 134, 25, 186, 6, 16, 203, 162, 149, 165, 133, 146, 224, 69, 29, 238,
          38, 34, 147, 140, 135, 85, 102, 118, 136, 218, 243, 82, 155,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`URI(string,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "URI(string,uint256)"
      }
    }
    impl self::ethcontract::web3::contract::tokens::Detokenize for Uri {
      fn from_tokens(
        tokens: Vec<self::ethcontract::common::abi::Token>,
      ) -> Result<Self, self::ethcontract::web3::contract::Error> {
        if tokens.len() != 2 {
          return Err(self::ethcontract::web3::contract::Error::InvalidOutputType(
            format!("Expected {} tokens, got {}: {:?}", 2, tokens.len(), tokens),
          ));
        }
        #[allow(unused_mut)]
        let mut tokens = tokens.into_iter();
        let value = <String as self::ethcontract::web3::contract::tokens::Tokenizable>::from_token(
          tokens.next().unwrap(),
        )?;
        let id = < self :: ethcontract :: U256 as self :: ethcontract :: web3 :: contract :: tokens :: Tokenizable > :: from_token (tokens . next () . unwrap ()) ? ;
        Ok(Uri { value, id })
      }
    }
  }
  impl Contract {
    #[doc = r" Retrieves a handle to a type containing for creating event"]
    #[doc = r" streams for all the contract events."]
    pub fn events(&self) -> Events<'_> {
      Events {
        instance: self.raw_instance(),
      }
    }
  }
  pub struct Events<'a> {
    instance: &'a self::ethcontract::dyns::DynInstance,
  }
  impl Events<'_> {
    #[doc = r" Generated by `ethcontract`."]
    pub fn approval_for_all(&self) -> self::event_builders::ApprovalForAllBuilder {
      self::event_builders::ApprovalForAllBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            23, 48, 126, 171, 57, 171, 97, 7, 232, 137, 152, 69, 173, 61, 89, 189, 150, 83, 242, 0,
            242, 32, 146, 4, 137, 202, 43, 89, 55, 105, 108, 49,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn transfer_batch(&self) -> self::event_builders::TransferBatchBuilder {
      self::event_builders::TransferBatchBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            74, 57, 220, 6, 212, 192, 219, 198, 75, 112, 175, 144, 253, 105, 138, 35, 58, 81, 138,
            165, 208, 126, 89, 93, 152, 59, 140, 5, 38, 200, 247, 251,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn transfer_single(&self) -> self::event_builders::TransferSingleBuilder {
      self::event_builders::TransferSingleBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            195, 213, 129, 104, 197, 174, 115, 151, 115, 29, 6, 61, 91, 191, 61, 101, 120, 84, 66,
            115, 67, 244, 192, 131, 36, 15, 122, 172, 170, 45, 15, 98,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn uri(&self) -> self::event_builders::UriBuilder {
      self::event_builders::UriBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            107, 183, 255, 112, 134, 25, 186, 6, 16, 203, 162, 149, 165, 133, 146, 224, 69, 29,
            238, 38, 34, 147, 140, 135, 85, 102, 118, 136, 218, 243, 82, 155,
          ]))
          .expect("generated event filter"),
      )
    }
  }
  #[doc = r" Module containing the generated event stream builders with type safe"]
  #[doc = r" filter methods for this contract's events."]
  pub mod event_builders {
    use super::ethcontract;
    use super::event_data;
    #[doc = "A builder for creating a filtered stream of `ApprovalForAll` events."]
    pub struct ApprovalForAllBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::ApprovalForAll>,
    );
    impl ApprovalForAllBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limit the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" The polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the account event parameter."]
      pub fn account(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the operator event parameter."]
      pub fn operator(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::ApprovalForAll>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::ApprovalForAll>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `TransferBatch` events."]
    pub struct TransferBatchBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::TransferBatch>,
    );
    impl TransferBatchBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limit the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" The polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the operator event parameter."]
      pub fn operator(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the from event parameter."]
      pub fn from(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the to event parameter."]
      pub fn to(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::TransferBatch>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::TransferBatch>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `TransferSingle` events."]
    pub struct TransferSingleBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::TransferSingle>,
    );
    impl TransferSingleBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limit the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" The polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the operator event parameter."]
      pub fn operator(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the from event parameter."]
      pub fn from(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the to event parameter."]
      pub fn to(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::TransferSingle>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::TransferSingle>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Uri` events."]
    pub struct UriBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Uri>,
    );
    impl UriBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limit the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" The polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the id event parameter."]
      pub fn id(mut self, topic: self::ethcontract::Topic<self::ethcontract::U256>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Uri>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Uri>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
  }
  impl Contract {
    #[doc = r" Returns a log stream with all events."]
    pub fn all_events(&self) -> self::ethcontract::dyns::DynAllEventsBuilder<Event> {
      self::ethcontract::dyns::DynAllEventsBuilder::new(
        self.raw_instance().web3(),
        self.address(),
        self.deployment_information(),
      )
    }
  }
  #[doc = r" A contract event."]
  #[derive(Clone, Debug, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
  pub enum Event {
    ApprovalForAll(self::event_data::ApprovalForAll),
    TransferBatch(self::event_data::TransferBatch),
    TransferSingle(self::event_data::TransferSingle),
    Uri(self::event_data::Uri),
  }
  impl self::ethcontract::contract::ParseLog for Event {
    fn parse_log(
      log: self::ethcontract::RawLog,
    ) -> Result<Self, self::ethcontract::errors::ExecutionError> {
      let standard_event = log . topics . get (0) . copied () . map (| topic | match topic { self :: ethcontract :: H256 ([23 , 48 , 126 , 171 , 57 , 171 , 97 , 7 , 232 , 137 , 152 , 69 , 173 , 61 , 89 , 189 , 150 , 83 , 242 , 0 , 242 , 32 , 146 , 4 , 137 , 202 , 43 , 89 , 55 , 105 , 108 , 49]) => Ok (Event :: ApprovalForAll (log . clone () . decode (& Contract :: artifact () . abi . event ("ApprovalForAll") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([74 , 57 , 220 , 6 , 212 , 192 , 219 , 198 , 75 , 112 , 175 , 144 , 253 , 105 , 138 , 35 , 58 , 81 , 138 , 165 , 208 , 126 , 89 , 93 , 152 , 59 , 140 , 5 , 38 , 200 , 247 , 251]) => Ok (Event :: TransferBatch (log . clone () . decode (& Contract :: artifact () . abi . event ("TransferBatch") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([195 , 213 , 129 , 104 , 197 , 174 , 115 , 151 , 115 , 29 , 6 , 61 , 91 , 191 , 61 , 101 , 120 , 84 , 66 , 115 , 67 , 244 , 192 , 131 , 36 , 15 , 122 , 172 , 170 , 45 , 15 , 98]) => Ok (Event :: TransferSingle (log . clone () . decode (& Contract :: artifact () . abi . event ("TransferSingle") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([107 , 183 , 255 , 112 , 134 , 25 , 186 , 6 , 16 , 203 , 162 , 149 , 165 , 133 , 146 , 224 , 69 , 29 , 238 , 38 , 34 , 147 , 140 , 135 , 85 , 102 , 118 , 136 , 218 , 243 , 82 , 155]) => Ok (Event :: Uri (log . clone () . decode (& Contract :: artifact () . abi . event ("URI") . expect ("generated event decode")) ?)) , _ => Err (self :: ethcontract :: errors :: ExecutionError :: from (self :: ethcontract :: common :: abi :: Error :: InvalidData)) , }) ;
      if let Some(Ok(data)) = standard_event {
        return Ok(data);
      }
      Err(self::ethcontract::errors::ExecutionError::from(
        self::ethcontract::common::abi::Error::InvalidData,
      ))
    }
  }
}
pub use self::erc1155::Contract as ERC1155;
