#![allow(non_camel_case_types)]
#![allow(dead_code)]

pub type Small = i8;
pub type Short = i16;
pub type Big = i32;
pub type Long = i64;
pub type Many = i128;
pub type Tar = isize;

pub type uSmall = u8;
pub type uShort = u16;
pub type uBig = u32;
pub type uLong = u64;
pub type uMany = u128;
pub type uTar = usize;

pub type Handle<T> = std::io::Result<T>;
pub type Maybe<T> = Option<T>;

pub type text = &'static str;
use std::io::*;
pub fn ERROR<T>(a: &'static str) -> std::io::Result<T> { Err(Error::new(ErrorKind::Other, a)) }

pub fn print_type_of<T>(_: &T) {
    println!("{}", std::any::type_name::<T>())
}
