use std::path::Path;

use crate::log::{debug, info};
use crate::{Plugin, RefIR};

pub fn plugin() -> Plugin {
	Box::new(|mut ir: RefIR| {
		info!("Prettifying links...");
		let files = ir.files.clone();
		let html_files = files.iter().filter(|(p, _)| match p.extension() {
			Some(ext) => ext == "html",
			None => false,
		});
		for (path, file) in html_files {
			let basename = path.file_stem().unwrap();
			let mut new_path = match path.parent() {
				Some(parent) => parent,
				None => Path::new(""),
			}
			.to_path_buf();
			new_path.push(basename);
			new_path.push(path.file_name().unwrap());
			new_path.set_file_name("index.html");
			debug!("{:?} -> {:?}", path, new_path);
			ir.files.remove(&path.to_path_buf());
			ir.files.insert(new_path, file.clone());
		}
	})
}

#[test]
fn it_works() {
	use crate::Shtola;
	use std::path::PathBuf;

	let mut s = Shtola::new();
	s.source("../fixtures/pretty_links");
	s.destination("../fixtures/dest_pretty_links");
	s.clean(true);
	s.register(plugin());
	let r = s.build().unwrap();
	assert!(r.files.contains_key(&PathBuf::from("hi/index.html")));
	assert!(r
		.files
		.contains_key(&PathBuf::from("subfolder/hello/index.html")));
}
