use shtola::{RefIR, ShFile, Shtola};
use std::path::PathBuf;

fn main() {
	minifemme::start(minifemme::LevelFilter::Info, minifemme::LogMode::Pretty);
	let mut s = Shtola::new();
	s.source("fixtures/simple");
	s.destination("fixtures/dest_write");
	s.clean(true);
	let mw = Box::new(|mut ir: RefIR| {
		// Get the file contents first
		// We have to clone here because otherwise there'll be an immutable ref lying around,
		// which prevents us from writing to the HashMap later on.
		let file = ir.files.get(&PathBuf::from("hello.txt")).unwrap().clone();
		ir.files.insert(
			"hello.txt".into(),
			ShFile {
				frontmatter: file.frontmatter,
				content: "hello".into(),
				raw_content: None,
			},
		);
	});
	s.register(mw);
	s.build().unwrap();
}
