use shtola::{Plugin, RefIR, ShFile, Shtola};
use std::time::SystemTime;

fn plugin() -> Plugin {
	Box::new(|mut ir: RefIR| {
		// Let's create our file in the IR (intermediate representation) file hash map!
		let current_time = SystemTime::now();
		ir.files.insert(
			"current_time.txt".into(),
			ShFile {
				content: format!("{:?}", current_time).into(),
				..ShFile::default()
			},
		);
	})
}

fn main() {
	minifemme::start(minifemme::LevelFilter::Info, minifemme::LogMode::Pretty);
	let mut s = Shtola::new();
	s.source("fixtures/empty");
	s.destination("fixtures/dest_systemtime");
	s.register(plugin());
	s.build().expect("Build failed!");
	// Now we have a "current_time.txt" file in our destination directory that
	// contains the current system time!
}
