use crate::ast::ast;

pub struct Environment {
    tables: Vec<Table>,
}

pub struct Table {}

pub enum TypecheckError {}

pub fn typecheck_statements(statements: Vec<ast::Statement>) -> Result<(), TypecheckError> {}

pub fn typecheck_statement(statement: ast::Statement) -> Result<(), TypecheckError> {
    match statement {
        ast::Statement::CreateTable {
            or_replace,
            temporary,
            external,
            if_not_exists,
            name,
            columns,
            constraints,
            hive_distribution,
            hive_formats,
            table_properties,
            with_options,
            file_format,
            location,
            query,
            without_rowid,
            like,
        } => {
            columns.into_iter().map(|column| {
                column
            })
        }
        ast::Statement::Analyze {
            table_name,
            partitions,
            for_columns,
            columns,
            cache_metadata,
            noscan,
            compute_statistics,
        } => {}
        ast::Statement::Truncate {
            table_name,
            partitions,
        } => {}
        ast::Statement::Msck {
            table_name,
            repair,
            partition_action,
        } => {}
        ast::Statement::Query(_) => {}
        ast::Statement::Insert {
            or,
            table_name,
            columns,
            overwrite,
            source,
            partitioned,
            after_columns,
            table,
        } => {}
        ast::Statement::Directory {
            overwrite,
            local,
            path,
            file_format,
            source,
        } => {}
        ast::Statement::Copy {
            table_name,
            columns,
            values,
        } => {}
        ast::Statement::Update {
            table_name,
            assignments,
            selection,
        } => {}
        ast::Statement::Delete {
            table_name,
            selection,
        } => {}
        ast::Statement::CreateView {
            or_replace,
            materialized,
            name,
            columns,
            query,
            with_options,
        } => {}
        ast::Statement::CreateVirtualTable {
            name,
            if_not_exists,
            module_name,
            module_args,
        } => {}
        ast::Statement::CreateIndex {
            name,
            table_name,
            columns,
            unique,
            if_not_exists,
        } => {}
        ast::Statement::AlterTable { name, operation } => {}
        ast::Statement::Drop {
            object_type,
            if_exists,
            names,
            cascade,
            purge,
        } => {}
        ast::Statement::SetVariable {
            local,
            hivevar,
            variable,
            value,
        } => {}
        ast::Statement::ShowVariable { variable } => {}
        ast::Statement::ShowColumns {
            extended,
            full,
            table_name,
            filter,
        } => {}
        ast::Statement::StartTransaction { modes } => {}
        ast::Statement::SetTransaction { modes } => {}
        ast::Statement::Commit { chain } => {}
        ast::Statement::Rollback { chain } => {}
        ast::Statement::CreateSchema {
            schema_name,
            if_not_exists,
        } => {}
        ast::Statement::CreateDatabase {
            db_name,
            if_not_exists,
            location,
            managed_location,
        } => {}
        ast::Statement::Assert { condition, message } => {}
        ast::Statement::Deallocate { name, prepare } => {}
        ast::Statement::Execute { name, parameters } => {}
        ast::Statement::Prepare {
            name,
            data_types,
            statement,
        } => {}
        ast::Statement::Explain {
            analyze,
            verbose,
            statement,
        } => {}
    };
    Ok(())
}
