/// Returns the path to the given program or an empty string.
pub fn which(program: String) -> String {
    let res = which::which(program);

    if res.is_ok() {
        res.unwrap().as_path().to_str().unwrap().to_string()
    } else {
        String::from("")
    }
}

#[cfg(test)]
mod tests {
    use std::path::Path;

    use crate::which;

    #[test]
    fn test_which() {
        if cfg!(target_os = "windows") {
            assert!(Path::new(&which::which("pwd".to_string())).exists())
        } else {
            assert!(Path::new(&which::which("pwd".to_string())).exists())
        }
        assert_eq!(which::which("fail".to_string()).is_empty(), true);
    }
}
