use std::error::Error;

#[derive(Clone)]
pub struct Command<T> {
    /// The function pointer which this links to.
    pub command: CommandFn<T>,
    /// A help string, should be less than 80 characters. For example, if it
    /// was an `echo` command:
    /// ```txt
    /// Prints the arguments to the output.
    /// ```
    pub help: String,
}

impl<T> Command<T> {
    pub fn new(help: String, command: CommandFn<T>) -> Self {
        Self { command, help }
    }
}

pub type CommandFn<T> = fn(&mut T, Vec<String>) -> Result<(), Box<dyn Error>>;
