// Copyright (c) 2021 Xu Shaohua <shaohua@biofan.org>. All rights reserved.
// Use of this source is governed by Apache-2.0 License that can be found
// in the LICENSE file.

use crate::core::pwd::getpwuid;
use crate::error::{Error, ErrorKind};

#[inline]
pub fn whoami() -> Result<String, Error> {
    let uid = nc::geteuid();
    match getpwuid(uid)? {
        None => Err(Error::from_string(
            ErrorKind::PwdError,
            format!("User with id {} not found", uid),
        )),
        Some(p) => Ok(p.name),
    }
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_whoami() {
        let env_user = std::env::var("USER");
        assert!(env_user.is_ok());
        let env_user = env_user.unwrap();

        let user = whoami();
        assert!(user.is_ok());
        let user = user.unwrap();
        assert_eq!(env_user, user);
    }
}
