// Copyright (c) 2021 Xu Shaohua <shaohua@biofan.org>. All rights reserved.
// Use of this source is governed by General Public License that can be found
// in the LICENSE file.

use std::path::Path;

use crate::error::Error;

/// Call the unlink function to remove the specified file.
pub fn unlink<P: AsRef<Path>>(file: P) -> Result<(), Error> {
    nc::unlinkat(nc::AT_FDCWD, file.as_ref(), 0).map_err(Into::into)
}

#[cfg(test)]
mod tests {
    use super::unlink;

    #[test]
    fn test_unlink() {
        let path = "/tmp/shell-rs-unlink";
        let ret = nc::open(path, nc::O_WRONLY | nc::O_CREAT, 0o644);
        assert!(ret.is_ok());
        let fd = ret.unwrap();
        assert!(nc::close(fd).is_ok());
        assert!(unlink(path).is_ok());
    }
}
