// Copyright (c) 2021 Xu Shaohua <shaohua@biofan.org>. All rights reserved.
// Use of this source is governed by Apache-2.0 License that can be found
// in the LICENSE file.

use crate::error::Error;

#[derive(Debug, Clone, Copy)]
pub struct Options {
    /// Allow the superuser to attempt to hard link directories
    /// (note: will probably fail due to system restrictions, even for the  supe‐ruser).
    pub directory: bool,

    /// Remove existing destination files.
    pub force: bool,

    /// Dereference TARGETs that are symbolic links.
    pub logical: bool,

    /// Treat LINK_NAME as a normal file if it is a symbolic link to a directory.
    pub no_dereference: bool,

    /// Make hard links directly to symbolic links.
    pub physical: bool,

    /// Create symbolic links relative to link location.
    pub symbolic: bool,
}

impl Default for Options {
    fn default() -> Self {
        Self {
            directory: false,
            force: false,
            logical: false,
            no_dereference: false,
            physical: false,
            symbolic: false,
        }
    }
}

/// Make links between files.
pub fn ln() {}
