// Copyright (c) 2021 Xu Shaohua <shaohua@biofan.org>. All rights reserved.
// Use of this source is governed by Apache-2.0 License that can be found
// in the LICENSE file.

use crate::core::misc::gethostname;
use crate::error::Error;

/// Get system's host name.
///
/// See hostname(1) and gethostname(3).
#[inline]
pub fn hostname() -> Result<String, Error> {
    gethostname()
}
