// Copyright (c) 2021 Xu Shaohua <shaohua@biofan.org>. All rights reserved.
// Use of this source is governed by Apache-2.0 License that can be found
// in the LICENSE file.

use crate::error::Error;

/// Convert C string slice to string slice
/// C string slice may be postfixed with multiple null characters.
pub fn cstr_to_str(input: &[u8]) -> Result<&str, Error> {
    let nul_index = input.iter().position(|&b| b == 0).unwrap_or(input.len());
    std::str::from_utf8(&input[0..nul_index]).map_err(Into::into)
}
