// Copyright (c) 2021 Xu Shaohua <shaohua@biofan.org>. All rights reserved.
// Use of this source is governed by Apache-2.0 License that can be found
// in the LICENSE file.

/// Returns the name of the user logged in on the controlling terminal of the process.
pub fn getlogin() -> Option<String> {
    std::env::var("LOGNAME").map(|s| s.to_string()).ok()
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_getlogin() {
        let ret = getlogin();
        assert!(ret.is_some());
    }
}
