// Copyright (c) 2021 Xu Shaohua <shaohua@biofan.org>. All rights reserved.
// Use of this source is governed by Apache-2.0 License that can be found
// in the LICENSE file.

use crate::core::arch::Arch;
use crate::core::str::cstr_to_str;
use crate::error::Error;

pub fn arch() -> Result<Arch, Error> {
    let mut uts = nc::utsname_t::default();
    let _ = nc::uname(&mut uts)?;
    let machine = cstr_to_str(&uts.machine)?;
    machine.parse::<Arch>()
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_arch() {
        let arch = arch();
        assert!(arch.is_ok());
    }
}
