
# shell-rs
[shell-rs][shell-rs] is rust reimplementation of common coreutils APIs.

## Usage
Add this to `Cargo.toml`:
```toml
[dependencies]
shell-rs = "0.1"
```

Add this to your crate:
```rust
extern crate shell_rs;
```

## Examples
Make directories recursively:
```rust
use shell_rs::{mkdir, MkDirOptions};

let mut options = MkDirOptions::new();
options.recursive = true;
options.mode = 0o700;
let ret = mkdir("/tmp/test1/test2", &options);
assert_eq!(ret, Ok(()));
```

Expand environment variables:
```rust
use shell_rs::expand_env;

let s = expand_env("${PWD}/a/$HOME/c.txt");
let pwd = std::env::current_dir().unwrap();
let home = std::env::home_dir().unwrap();
let s2 = format!(
    "{}/a/{}/c.txt",
    pwd.to_str().unwrap(),
    home.to_str().unwrap()
);
assert_eq!(s, s2);
```

## Related projects
* [coreutils][coreutils], cross-platform Rust rewrite of the GNU coreutils
* [fs_extra][fs_extra], expanding opportunities standard library std::fs and std::io


[shell-rs]: https://github.com/XuShaohua/shell-rs
[coreutils]: https://github.com/uutils/coreutils
[fs_extra]: https://github.com/webdesus/fs_extra

## License
This library is release in [Apache License](LICENSE).
