// Copyright (c) 2021 Xu Shaohua <shaohua@biofan.org>. All rights reserved.
// Use of this source is governed by General Public License that can be found
// in the LICENSE file.

use crate::error::Error;

/// Get niceness of process.
pub fn nice(pid: i32) -> Result<i32, Error> {
    nc::getpriority(nc::PRIO_PROCESS, pid).map_err(Into::into)
}

#[cfg(test)]
mod tests {
    use super::nice;

    #[test]
    fn test_nice() {
        let ret = nice(nc::getpid());
        assert!(ret.is_ok());
    }
}
