// Copyright (c) 2021 Xu Shaohua <shaohua@biofan.org>. All rights reserved.
// Use of this source is governed by Apache-2.0 License that can be found
// in the LICENSE file.

use std::fs::File;
use std::io::Read;

use crate::error::Error;

/// Tell how long the system has been running.
/// Returns seconds since system bootup.
pub fn uptime() -> Result<u64, Error> {
    let mut fd = File::open("/proc/uptime")?;
    let mut content = String::new();
    fd.read_to_string(&mut content)?;
    let idx = content.find(char::is_whitespace).unwrap_or(content.len());
    let uptime_secs: f64 = content[0..idx].parse()?;
    Ok(uptime_secs as u64)
}

#[cfg(test)]
mod tests {
    use super::uptime;

    #[test]
    fn test_uptime() {
        let ret = uptime();
        assert!(ret.is_ok());
    }
}
