// Copyright (c) 2021 Xu Shaohua <shaohua@biofan.org>. All rights reserved.
// Use of this source is governed by Apache-2.0 License that can be found
// in the LICENSE file.

use std::str::FromStr;

use crate::error::{Error, ErrorKind};

#[derive(Debug)]
pub enum Arch {
    AArch64,
    Arm,
    X86,
    X86_64,
}

impl FromStr for Arch {
    type Err = Error;

    fn from_str(input: &str) -> Result<Self, Self::Err> {
        match input {
            "arm64" => Ok(Arch::AArch64),
            "aarch64" => Ok(Arch::AArch64),

            "x86" => Ok(Arch::X86),
            "i386" => Ok(Arch::X86),
            "i686" => Ok(Arch::X86),

            "x86_64" => Ok(Arch::X86_64),
            "amd64" => Ok(Arch::X86_64),
            _ => Err(Error::from_string(
                ErrorKind::InvalidArchError,
                format!("Invalid arch {}", input),
            )),
        }
    }
}
