use std::{io::Write, process::Command};

pub fn zfs_mount(path: String) {
    let mut mount = Command::new("zfs")
        .arg("mount")
        .arg(path)
        .spawn()
        .expect("Failes to initialize ZFS mount");
    mount.wait().expect("Failed to mount dataset");
}

pub fn zfs_loadkey(key: String, path: String) {
    let mut mount = Command::new("zfs") // Call zfs mount
        .arg("load-key")
        .arg("-L")
        .arg("prompt")
        .arg(&path)
        .stdin(std::process::Stdio::piped())
        .spawn()
        .expect("Failed zfs load-key");

    mount
        .stdin // Supply encryption key via stdin
        .as_mut()
        .expect("failed to get zfs stdin")
        .write_all(&key.as_bytes())
        .expect("Failed to write to stdin");

    mount.wait().expect("Failed to load key");
}

pub fn zfs_create(key: String, path: String) {
    let mut make = Command::new("zfs")
        .arg("create")
        .arg("-o")
        .arg("encryption=aes-256-gcm")
        .arg("-o")
        .arg("keyformat=passphrase")
        .arg("-o")
        .arg("keylocation=prompt")
        .arg(path)
        .stdin(std::process::Stdio::piped())
        .spawn()
        .expect("Failed to Create ZFS dataset");

    make.stdin // Supply encryption key via stdin
        .as_mut()
        .expect("failed to get zfs stdin")
        .write_all(&key.as_bytes())
        .expect("Failed to write to stdin");

    make.wait().expect("Failed to Create ZFS dataset");
}

pub fn zfs_lock(path: String) {
    let mut umount = Command::new("zfs")
        .arg("umount")
        .arg(&path)
        .spawn()
        .expect("Failed to unmount dataset");

    umount.wait().expect("Failed to unmount dataset");

    let mut unload = Command::new("zfs")
        .arg("unload-key")
        .arg(&path)
        .spawn()
        .expect("Failed to unload key");

    unload.wait().expect("Failed to unload key");
}
