use hex::encode;
use sha2::{Digest, Sha512};
use std::{fs::File, io::Write};

use crate::zfs::zfs_create;

pub fn shamir_new(threshold: u8, shares: u8, path: String) {
    let s1: [u8; 32] = rand::random();
    let s2: [u8; 32] = rand::random();
    let secret = [s1, s2].concat(); // Get 64 bytes of random data
    let zkey = encode(Sha512::digest(encode(secret).as_bytes())); // Digest and encode random data

    let shamir = shamir::SecretData::with_secret(&zkey.to_string(), threshold);

    let mut sharecount = 1;
    while sharecount <= shares {
        let mut fname = String::from("share ");
        fname.push_str(format!("{}.txt", sharecount).as_str());
        let fname = fname.to_string();
        let mut f = File::create(fname).expect("Failed to create new share file");
        let sharefile = shamir.get_share(sharecount).unwrap();
        let sharefile = encode(sharefile);
        f.write_all(&sharefile.as_bytes())
            .expect("Failed writing to file");
        sharecount += 1;
    }

    let mut master = File::create("MASTER KEY.txt").expect("Failed creating master key file");
    master
        .write_all(&zkey.as_bytes())
        .expect("Failed to write to MASTER key file");

    zfs_create(zkey, path);
}
