# Shavee

[![GitHub license](https://img.shields.io/badge/license-MIT-blue)](https://github.com/ashuio/shavee/blob/master/LICENSE)
![rust workflow](https://github.com/ashuio/zauthrs/actions/workflows/rust.yml/badge.svg)

Shavee is a shamir implementation for use with the ZFS filesystem written in Rust.

**CAUTION:** This is an EXPERIMENTAL program and should be treated only as a PoC.

## Build and Install
1. Install [Rust](https://www.rust-lang.org/tools/install)
2. Clone repo using 
```bash 
git clone https://github.com/ashuio/shavee.git 
```

3. Build using
```bash
cargo build --release 
```
4. Place the binary in your bin directory with 
```bash
sudo cp target/release/shavee /usr/bin
```

## Terms

* Threshold: Minimum number of shares required to unlock secret key.
* Shares: Shares are like part of a secret key which you can distribute and later derive the sme key again using N number of shares defined at creation.

## Usage

This command has Three main functions with supported arguments.

1. **Create: Can be used using the `-n` flag and basically creates a new dataset with the shamir encryption key.**

Use
```bash
shavee -n -t <Threshold> -s <No. of shares desired> -d <New dataset path>
```

Example
```bash
./shavee -n -t 2 -s 5 -d zroot/data/home/hunter/secretdata
```

This will create Shares in you current directory as "share 1.txt etc".

**Note:** Right now it also writes a "MASTER KEY.txt" file with master key to backup.

2. **Unlock: Unlocks a shamir encrypted dataset can be used with the `-u` flag**

Use

```bash
shavee -u -t <Threshold> -d <dataset> -f <Share files> ...
```

Example

```bash
shavee -u -t 2 -d zroot/secrets -f ./share1.txt -f./share2.txt
```

**Note: Threshold is set when creating a dataset and you must use the same value to unlock.**

3. **Lock: Unloads encryption key and unmounts dataset, use with `-l` flag (flag is lowercase `L`)**

Use
```bash
shavee -l -d <dataset>
```

Example
```bash
shavee -l -d zroot/secrets
```
