use super::*;
use crate::*;

#[test]
fn test_component_group_len() {
    fn test_group_len<'r, C: ComponentGroup<'r>>(expected_len: usize) {
        assert_eq!(C::LENGTH as u8 as usize, expected_len);
    }

    test_group_len::<Position>(1);
    test_group_len::<(Position, Rotation)>(2);
    test_group_len::<(Position, Rotation, Velocity)>(3);
}

#[cfg(feature = "const_type_name")]
#[test]
fn test_component_group_descriptor() {
    fn test_descriptor<'r, C: ComponentGroup<'r>>(ids: &[ComponentId]) {
        let arch = C::DESCRIPTORS;
        assert_eq!(arch.len(), ids.len());
        for (idx, elem) in arch.iter().enumerate() {
            assert_eq!(ids[idx], elem.component_id);
        }
    }

    // Check mapping indices
    // PositionID = 2360, RotationID = 49434 => (Pos, Rot),
    // thus correct mapping (Pos, Rot) => (0, 1), (Rot, Pos) => (1, 0) for sorted -> unsorted.
    // thus correct mapping (Pos, Rot) => (0, 1), (Rot, Pos) => (1, 0) for unsorted -> sorted.

    assert!(<(Position, Rotation)>::SORTED_TO_UNSORTED_MAPPING_INDICES[0] == 0);
    assert!(<(Position, Rotation)>::SORTED_TO_UNSORTED_MAPPING_INDICES[1] == 1);

    assert!(<(Rotation, Position)>::SORTED_TO_UNSORTED_MAPPING_INDICES[0] == 1);
    assert!(<(Rotation, Position)>::SORTED_TO_UNSORTED_MAPPING_INDICES[1] == 0);

    assert!(<(Position, Rotation)>::UNSORTED_TO_SORTED_MAPPING_INDICES[0] == 0);
    assert!(<(Position, Rotation)>::UNSORTED_TO_SORTED_MAPPING_INDICES[1] == 1);

    assert!(<(Rotation, Position)>::UNSORTED_TO_SORTED_MAPPING_INDICES[0] == 1);
    assert!(<(Rotation, Position)>::UNSORTED_TO_SORTED_MAPPING_INDICES[1] == 0);

    assert!(<(Position, Rotation)>::GROUP_ID == <(Rotation, Position)>::GROUP_ID);

    test_descriptor::<(Position, Rotation)>(&[Position::ID, Rotation::ID]);
}
