#[cfg(test)]
use super::*;
#[cfg(test)]
use crate::*;
#[cfg(test)]
use std::convert::*;

#[test]
pub fn test_archetype_registry() {
    let mut component_types = vec![
        ComponentDescriptor::from_component::<Rotation>(),
        ComponentDescriptor::from_component::<Position>(),
    ];
    component_types.sort_by_key(|e| e.component_id);
    let mut registry =
        ArchetypeRegistry::try_from((component_types, DEFAULT_MAX_COMPONENTS_PER_POOL)).unwrap();

    let info = registry.get_or_alloc_pool_from_group::<Position>().unwrap();
    unsafe {
        for i in 0..DEFAULT_MAX_COMPONENTS_PER_POOL {
            let _ = info.archetype_pool.push_entity_unchecked(
                EntityMetadata::default(),
                Position {
                    x: 1.0 * i as f32,
                    y: 2.0 * i as f32,
                    z: 3.0 * i as f32,
                },
            );
        }

        for i in 0..DEFAULT_MAX_COMPONENTS_PER_POOL {
            let p = info
                .archetype_pool
                .get_component_unchecked::<Position>(&Position::ARCHETYPE_DESCRIPTOR, i as u16);
            assert_eq!(p.x, i as f32 * 1.0);
            assert_eq!(p.y, i as f32 * 2.0);
            assert_eq!(p.z, i as f32 * 3.0);
        }

        // let p = pool.read_entity_unchecked::<Position>(v);

        // std::mem::forget(p);
    }
}
