use crate::*;

/// Internal metadata type used for reverse lookups.
/// 8 bits available for arbitrary flags.
#[derive(Debug, Clone, Copy)]
#[repr(transparent)]
pub(crate) struct EntityMetadata(Entity);

impl From<Entity> for EntityMetadata {
    fn from(v: Entity) -> Self {
        Self { 0: v }
    }
}

impl EntityMetadata {
    #[allow(dead_code)]
    pub fn entity(&self) -> Entity {
        self.0
    }

    #[allow(dead_code)]
    pub fn entity_zeroed_version(&self) -> Entity {
        let mut e = self.0;
        e.set_version(0);
        e
    }
}

impl Default for EntityMetadata {
    fn default() -> Self {
        Self(Entity::from_raw(0))
    }
}
