/// Represents a pointer into a given component allocation.
/// Be careful when using this, the actual amount of bytes it points
/// to is determined by the Component's allocator.
#[derive(Debug, Clone, Copy, PartialEq, Eq, Hash)]
pub struct ComponentPool {
    ptr: *mut u8,
}

impl From<*mut u8> for ComponentPool {
    fn from(value: *mut u8) -> Self {
        Self { ptr: value }
    }
}

impl ComponentPool {
    /// Constructs a ComponentPool from a nullptr. MUST not be used as valid component pool.
    pub(crate) unsafe fn zeroed() -> Self {
        Self {
            ptr: std::ptr::null_mut(),
        }
    }

    /// Returns raw pointer of the component pool.
    pub(crate) unsafe fn as_ptr(&self) -> *mut u8 {
        self.ptr
    }
}
