#[macro_export]
macro_rules! define_component_descriptor {
    ($item:ident) => {
        ComponentDescriptor {
            component_id: $item::ID,
            allocation_size: <$item::Allocator as ComponentAllocator<'_, $item>>::ALLOCATION_SIZE,
            allocation_alignment:
                <$item::Allocator as ComponentAllocator<'_, $item>>::ALLOCATION_ALIGNMENT,
            pool_count: $item::POOLS_PER_ALLOCATION,
            pool_stride: <$item::Allocator as ComponentAllocator<'_, $item>>::POOL_STRIDE,
            allocator_fns: AbstractComponentAllocatorDescriptor {
                write_to_pool:
                    <$item::Allocator as ComponentAllocator<'_, $item>>::write_component_memory,
                read_from_pool:
                    <$item::Allocator as ComponentAllocator<'_, $item>>::read_component_memory,
                drop_in_pool:
                    <$item::Allocator as ComponentAllocator<'_, $item>>::drop_component_memory,
                move_component: <$item::Allocator as ComponentAllocator<'_, $item>>::move_component,
            },
        }
    };
}

macro_rules! expr {
    ($x:expr) => {
        $x
    };
}

macro_rules! tuple_index {
    ($tuple:expr, $idx:tt) => {
        expr!($tuple.$idx)
    };
}

#[macro_export]
macro_rules! define_test_components {
    () => {
        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Position {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Position {
            #[cfg(not(feature = "const_type_name"))]
            const NAME: &'static str = "Position";
            type Allocator = DefaultAllocator;
        }

        impl Default for Position {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct PositionSeparateAllocs {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for PositionSeparateAllocs {
            type Allocator = DefaultAllocator;
            #[cfg(not(feature = "const_type_name"))]
            const NAME: &'static str = "PositionSeparateAllocs";
            const POOLS_PER_ALLOCATION: usize = 1;
        }

        impl Default for PositionSeparateAllocs {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct PositionMassiveAllocs {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for PositionMassiveAllocs {
            type Allocator = DefaultAllocator;
            #[cfg(not(feature = "const_type_name"))]
            const NAME: &'static str = "PositionMassiveAllocs";
            const POOLS_PER_ALLOCATION: usize = 4096;
        }

        impl Default for PositionMassiveAllocs {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Velocity {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Default for Velocity {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        impl Component for Velocity {
            #[cfg(not(feature = "const_type_name"))]
            const NAME: &'static str = "Velocity";
            type Allocator = DefaultAllocator;
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Rotation {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Rotation {
            #[cfg(not(feature = "const_type_name"))]
            const NAME: &'static str = "Rotation";
            type Allocator = DefaultAllocator;
        }

        impl Default for Rotation {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone)]
        pub struct RotationMassiveAllocs {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for RotationMassiveAllocs {
            #[cfg(not(feature = "const_type_name"))]
            const NAME: &'static str = "RotationMassiveAllocs";
            const POOLS_PER_ALLOCATION: usize = 4096;
            type Allocator = DefaultAllocator;
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone)]
        pub struct RotationSeparateAllocs {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for RotationSeparateAllocs {
            #[cfg(not(feature = "const_type_name"))]
            const NAME: &'static str = "RotationSeparateAllocs";
            const POOLS_PER_ALLOCATION: usize = 4096;
            type Allocator = DefaultAllocator;
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone)]
        pub struct Transform {
            pub matrix: [f32; 16],
        }
        impl Component for Transform {
            #[cfg(not(feature = "const_type_name"))]
            const NAME: &'static str = "Transform";
            type Allocator = DefaultAllocator;
        }
    };
}
