/// Largest amount of components possible for a single entity.
/// Is defined to be 16 at most.
pub const MAX_COMPONENTS_PER_ENTITY: usize = 16;

/// Used amount of bits in the entityhandle for storing the index.
/// Is defined to be 24 bits. Thus, yielding 2^24 = 16_777_216 different indices/entities.
pub const ENTITY_INDEX_BITS: u8 = 24;

pub const MAX_ENTITY_HANDLE_VALUE: usize = 16_777_215;

/// Max amount of unique archetypes that can exist. Defined to be 2^16 - 1.
/// Therefore, a u16 can be used to store the index of the archetype.
/// u16::MAX is used to mark validness of such an archetype index.
pub const MAX_ARCHETYPE_COUNT: usize = 65535;

/// Max amount of pools per archetype that can exist.
/// Is defined to be 65536: 2^16. As at most all entities can have 1 component of a given type.
/// Therefore, pool_count * components_per_pool == entity_count must hold.
pub const MAX_ARCHETYPE_POOL_COUNT: usize = 65536;

/// Used amount of bits in an entityhandle for storing the version.
/// Is defined to be 8 bits. Thus, yielding 2^8 = 256 different versions.
pub const ENTITY_GENERATION_BITS: u8 = 8;

/// Largest amount of entities than can be inserted into the registry.
/// Is defined to be: 16_777_216
pub const MAX_ENTITIES: usize = usize::pow(ENTITY_INDEX_BITS as usize, 2);

/// Amount of component instances in each pool.
pub const DEFAULT_MAX_COMPONENTS_PER_POOL: u16 = 1024;
