// use crate::*;
// use std::marker::PhantomData;

// struct ExactArchetypePoolRef<'a> {
//     pools: &'a [ComponentPool],
//     length: usize,
// }

// pub struct EntityComponentIteratorExact<'r, C: ComponentGroup<'r>> {
//     _phantom: PhantomData<fn(&'r C)>,
//     pools: Vec<ExactArchetypePoolRef<'r>>,
//     idx: usize,
// }

// impl<'r, C: ComponentGroup<'r>> EntityComponentIteratorExact<'r, C> {
//     pub(crate) unsafe fn new(pools: &'r [ArchetypePool]) -> Self {
//         if pools.is_empty() {
//             return Self {
//                 _phantom: PhantomData::default(),
//                 pools: Vec::with_capacity(0),
//                 idx: 0,
//             };
//         }

//         let mut new_pools: Vec<ExactArchetypePoolRef<'r>> = Vec::with_capacity(pools.len());

//         let mut idx = 0;
//         while idx < pools.len() - 1 {
//             let mut increment_idx = idx;
//             let mut pool_increment_counter = 1;
//             let mut element_counter: usize = 0;
//             while C::is_coalescable(
//                 pools
//                     .get_unchecked(increment_idx)
//                     .pools_as_slice_unchecked(),
//                 pools
//                     .get_unchecked(increment_idx + 1)
//                     .pools_as_slice_unchecked(),
//             ) {
//                 pool_increment_counter += 1;
//                 increment_idx += 1;
//                 element_counter += pools.get_unchecked(increment_idx + 1).len() as usize;
//             }
//             // We can coalesce the pools perhaps?

//             new_pools.push(ExactArchetypePoolRef {
//                 pools: pools.get_unchecked(idx).pools_as_slice_unchecked(),
//                 length: pools.get_unchecked(idx).len() as usize + element_counter,
//             });

//             idx += pool_increment_counter;
//         }
//         new_pools.push(ExactArchetypePoolRef {
//             pools: pools
//                 .get_unchecked(pools.len() - 1)
//                 .pools_as_slice_unchecked(),
//             length: pools.get_unchecked(pools.len() - 1).len() as usize,
//         });

//         Self {
//             _phantom: PhantomData::default(),
//             pools: new_pools,
//             idx: 0,
//         }
//     }

//     pub fn reset(&mut self) {
//         self.idx = 0;
//     }
// }

// impl<'r, G: ComponentGroup<'r>> Iterator for EntityComponentIteratorExact<'r, G> {
//     type Item = G::SliceRefTuple;

//     fn next(&mut self) -> Option<Self::Item> {
//         return if self.idx < self.pools.len() {
//             self.idx += 1;
//             Some(unsafe {
//                 G::get_slice_unchecked(
//                     self.pools.get_unchecked(self.idx - 1).pools,
//                     self.pools.get_unchecked(self.idx - 1).length as usize,
//                 )
//             })
//         } else {
//             None
//         };
//     }
// }

// struct ExactArchetypePoolMutRef<'a> {
//     pools: &'a mut [ComponentPool],
//     length: usize,
// }

// pub struct EntityComponentIteratorExactMut<'r, C: ComponentGroup<'r>> {
//     _phantom: PhantomData<fn(&'r mut C)>,
//     pools: Vec<ExactArchetypePoolMutRef<'r>>,
//     idx: usize,
// }

// impl<'r, C: ComponentGroup<'r>> EntityComponentIteratorExactMut<'r, C> {
//     pub(crate) unsafe fn new(pools: &'r mut [ArchetypePool]) -> Self {
//         if pools.is_empty() {
//             return Self {
//                 _phantom: PhantomData::default(),
//                 pools: Vec::with_capacity(0),
//                 idx: 0,
//             };
//         }

//         let mut new_pools: Vec<ExactArchetypePoolMutRef<'r>> = Vec::with_capacity(pools.len());

//         let mut idx = 0;
//         let len_min_one = pools.len() - 1;
//         while idx < len_min_one {
//             let mut increment_idx = idx;
//             let mut pool_increment_counter = 1;
//             let mut element_counter: usize = 0;
//             while C::is_coalescable(
//                 pools
//                     .get_unchecked(increment_idx)
//                     .pools_as_slice_unchecked(),
//                 pools
//                     .get_unchecked(increment_idx + 1)
//                     .pools_as_slice_unchecked(),
//             ) {
//                 pool_increment_counter += 1;
//                 increment_idx += 1;
//                 element_counter += pools.get_unchecked(increment_idx + 1).len() as usize;
//             }
//             // We can coalesce the pools perhaps?

//             {
//                 let ptr: *mut ArchetypePool = pools.get_unchecked_mut(idx);
//                 new_pools.push(ExactArchetypePoolMutRef {
//                     pools: (*ptr).pools_as_mut_slice_unchecked(),
//                     length: (*ptr).len() as usize + element_counter,
//                 });
//             }

//             idx += pool_increment_counter;
//         }
//         {
//             let ptr: *mut ArchetypePool = pools.get_unchecked_mut(pools.len() - 1);
//             new_pools.push(ExactArchetypePoolMutRef {
//                 pools: (*ptr).pools_as_mut_slice_unchecked(),
//                 length: (*ptr).len() as usize,
//             });
//         }

//         Self {
//             _phantom: PhantomData::default(),
//             pools: new_pools,
//             idx: 0,
//         }
//     }

//     pub fn reset(&mut self) {
//         self.idx = 0;
//     }
// }

// impl<'r, G: ComponentGroup<'r>> Iterator for EntityComponentIteratorExactMut<'r, G> {
//     type Item = G::SliceMutRefTuple;

//     fn next(&mut self) -> Option<Self::Item> {
//         return if self.idx < self.pools.len() {
//             self.idx += 1;
//             Some(unsafe {
//                 G::get_slice_mut_unchecked(
//                     self.pools.get_unchecked(self.idx - 1).pools,
//                     self.pools.get_unchecked(self.idx - 1).length as usize,
//                 )
//             })
//         } else {
//             None
//         };
//     }
// }
