use crate::utils::fnv1a::*;
use crate::{ComponentAllocator, ComponentId};

/// Trait implemented for all types to be used as components.
pub trait Component: Sized + 'static {
    /// Name used for a component. MUST be unique across the program.
    #[cfg(feature = "const_type_name")]
    const NAME: &'static str = std::any::type_name::<Self>();
    #[cfg(not(feature = "const_type_name"))]
    const NAME: &'static str;
    /// ID used for identifying components. MUST be unique across the program.
    const ID: ComponentId = ComponentId::from_u16(fnv1a_hash_str_16_xor(Self::NAME));
    /// Amount of pools per allocation. MUST be respected by the allocator. Amount of components per allocation is therefore POOLS_PER_ALLOCATION * COMPONENTS_PER_POOL.
    const POOLS_PER_ALLOCATION: usize = 4;
    /// Allocator associated type trait for allocating instances of this component.
    type Allocator: for<'s> ComponentAllocator<'s, Self>;
}
