use std::fmt::Display;

/// Represents the unique subset of components as a comparable identifier.
#[repr(transparent)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub struct ArchetypeId(u32);

impl From<u32> for ArchetypeId {
    fn from(v: u32) -> Self {
        Self(v)
    }
}

impl ArchetypeId {
    #[inline(always)]
    pub const fn from_u32(v: u32) -> Self {
        ArchetypeId(v)
    }

    #[inline(always)]
    pub const fn into_u32(self) -> u32 {
        self.0
    }
}

impl Display for ArchetypeId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.0)
    }
}

impl ArchetypeId {
    #[inline(always)]
    pub fn to_ne_bytes(self) -> [u8; 4] {
        self.0.to_ne_bytes()
    }
}
