use crate::ComponentId;

/// Defines properties for a particular known component.
/// The id field is used for comparisons and ordering.
#[derive(Debug)]
pub struct ComponentRegistrationRecord {
    /// id of the registered component.
    pub id: ComponentId,
    /// name of the registered component.
    pub name: &'static str,
    /// size of the registered component.
    pub size: usize,
    /// alignment of the registered component.
    pub align: usize,
}

impl Eq for ComponentRegistrationRecord {}
impl PartialEq for ComponentRegistrationRecord {
    fn eq(&self, other: &Self) -> bool {
        self.id == other.id
    }
}
impl Ord for ComponentRegistrationRecord {
    fn cmp(&self, other: &Self) -> std::cmp::Ordering {
        self.id.cmp(&other.id)
    }
}
impl PartialOrd for ComponentRegistrationRecord {
    fn partial_cmp(&self, other: &Self) -> Option<std::cmp::Ordering> {
        Some(self.id.cmp(&other.id))
    }
}