#[macro_export]
macro_rules! define_component_descriptor {
    ($item:ident) => {
        ComponentDescriptor {
            component_id: $item::ID,
            allocation_size: <$item::Allocator as ComponentAllocator<'_, $item>>::ALLOCATION_SIZE,
            allocation_alignment:
                <$item::Allocator as ComponentAllocator<'_, $item>>::ALLOCATION_ALIGNMENT,
            pool_count: $item::POOLS_PER_ALLOCATION,
            pool_stride: <$item::Allocator as ComponentAllocator<'_, $item>>::POOL_STRIDE,
            allocator_fns: AbstractComponentAllocatorDescriptor {
                write_to_pool:
                    <$item::Allocator as ComponentAllocator<'_, $item>>::write_component_memory,
                read_from_pool:
                    <$item::Allocator as ComponentAllocator<'_, $item>>::read_component_memory,
                drop_in_pool:
                    <$item::Allocator as ComponentAllocator<'_, $item>>::drop_component_memory,
                move_component: <$item::Allocator as ComponentAllocator<'_, $item>>::move_component,
            },
        }
    };
}

macro_rules! expr {
    ($x:expr) => {
        $x
    };
}

macro_rules! tuple_index {
    ($tuple:expr, $idx:tt) => {
        expr!($tuple.$idx)
    };
}

#[macro_export]
macro_rules! define_special_alloc_size_components {
    () => {
        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Position1Alloc {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Position1Alloc {
            type Allocator = DefaultAllocator;
            const NAME = "Position1Alloc";
            const POOLS_PER_ALLOCATION: usize = 1;
        }

        impl Default for Position1Alloc {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Position2Alloc {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Position2Alloc {
            type Allocator = DefaultAllocator;
            const NAME = "Position2Alloc";
            const POOLS_PER_ALLOCATION: usize = 2;
        }

        impl Default for Position2Alloc {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Position4Alloc {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Position4Alloc {
            type Allocator = DefaultAllocator;
            const NAME = "Position4Alloc";
            const POOLS_PER_ALLOCATION: usize = 4;
        }

        impl Default for Position4Alloc {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Position6Alloc {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Position6Alloc {
            type Allocator = DefaultAllocator;
            const NAME = "Position6Alloc";
            const POOLS_PER_ALLOCATION: usize = 6;
        }

        impl Default for Position6Alloc {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Position8Alloc {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Position8Alloc {
            type Allocator = DefaultAllocator;
            const NAME = "Position8Alloc";
            const POOLS_PER_ALLOCATION: usize = 8;
        }

        impl Default for Position8Alloc {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Position12Alloc {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Position12Alloc {
            type Allocator = DefaultAllocator;
            const NAME = "Position12Alloc";
            const POOLS_PER_ALLOCATION: usize = 12;
        }

        impl Default for Position12Alloc {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Position16Alloc {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Position16Alloc {
            type Allocator = DefaultAllocator;
            const NAME = "Position16Alloc";
            const POOLS_PER_ALLOCATION: usize = 16;
        }

        impl Default for Position16Alloc {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Position24Alloc {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Position24Alloc {
            type Allocator = DefaultAllocator;
            const NAME = "Position24Alloc";
            const POOLS_PER_ALLOCATION: usize = 24;
        }

        impl Default for Position24Alloc {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Position32Alloc {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Position32Alloc {
            type Allocator = DefaultAllocator;
            const NAME = "Position32Alloc";
            const POOLS_PER_ALLOCATION: usize = 32;
        }

        impl Default for Position32Alloc {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Position4096Alloc {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Position4096Alloc {
            type Allocator = DefaultAllocator;
            const POOLS_PER_ALLOCATION: usize = 4096;
        }

        impl Default for Position4096Alloc {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }
    };
}

#[macro_export]
macro_rules! define_test_components {
    () => {
        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Position {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Position {
            const NAME: &'static str = "Position";
            type Allocator = DefaultAllocator;
        }

        impl Default for Position {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct PositionSeparateAllocs {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for PositionSeparateAllocs {
            type Allocator = DefaultAllocator;
            const NAME: &'static str = "PositionSeparateAllocs";
            const POOLS_PER_ALLOCATION: usize = 1;
        }

        impl Default for PositionSeparateAllocs {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct PositionMassiveAllocs {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for PositionMassiveAllocs {
            type Allocator = DefaultAllocator;
            const NAME: &'static str = "PositionMassiveAllocs";
            const POOLS_PER_ALLOCATION: usize = 4096;
        }

        impl Default for PositionMassiveAllocs {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Velocity {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Default for Velocity {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        impl Component for Velocity {
            const NAME: &'static str = "Velocity";
            type Allocator = DefaultAllocator;
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone, Copy)]
        pub struct Rotation {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for Rotation {
            const NAME: &'static str = "Rotation";
            type Allocator = DefaultAllocator;
        }

        impl Default for Rotation {
            fn default() -> Self {
                Self {
                    x: 1.0,
                    y: 2.0,
                    z: 3.0,
                }
            }
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone)]
        pub struct RotationMassiveAllocs {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for RotationMassiveAllocs {
            const NAME: &'static str = "RotationMassiveAllocs";
            const POOLS_PER_ALLOCATION: usize = 4096;
            type Allocator = DefaultAllocator;
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone)]
        pub struct RotationSeparateAllocs {
            pub x: f32,
            pub y: f32,
            pub z: f32,
        }

        impl Component for RotationSeparateAllocs {
            const NAME: &'static str = "RotationSeparateAllocs";
            const POOLS_PER_ALLOCATION: usize = 4096;
            type Allocator = DefaultAllocator;
        }

        #[repr(C)]
        #[derive(Debug, PartialEq, Clone)]
        pub struct Transform {
            pub matrix: [f32; 16],
        }
        impl Component for Transform {
            const NAME: &'static str = "Transform";
            type Allocator = DefaultAllocator;
        }
    };
}
