use std::fmt::Display;

/// Represents the type of a Component as an identifier.
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[repr(transparent)]
pub struct ComponentId(u16);

impl From<u16> for ComponentId {
    fn from(v: u16) -> Self {
        Self(v)
    }
}

impl ComponentId {
    #[inline(always)]
    pub const fn from_u16(v: u16) -> Self {
        Self(v)
    }

    #[inline(always)]
    pub const fn into_u16(self) -> u16 {
        self.0
    }
}

impl ComponentId {
    #[inline(always)]
    pub const fn to_ne_bytes(self) -> [u8; 2] {
        self.0.to_ne_bytes()
    }
}

impl Display for ComponentId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.0)
    }
}
