use super::component_alloc_error::*;
use std::{error::Error, fmt::Display};

/// General ECS error type.
#[derive(Debug, PartialEq, Eq)]
pub enum ECSError {
    InvalidEntity,
    EntityLimitExceeded,
    ArchetypeCountLimitExceeded,
    ArchetypePoolCountLimitExceeded,
    ComponentAllocError(ComponentAllocError),
}

impl Display for ECSError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        return match self {
            ECSError::ArchetypeCountLimitExceeded => {
                write!(f, "Exceeded amount of archetypes that can be stored.")
            }
            ECSError::ArchetypePoolCountLimitExceeded => {
                write!(
                    f,
                    "Exceeded amount of pools that can be stored for a given archetype."
                )
            }
            ECSError::ComponentAllocError(v) => v.fmt(f),
            ECSError::EntityLimitExceeded => {
                write!(f, "Exceed amound of entities that can be stored.")
            }
            ECSError::InvalidEntity => {
                write!(f, "Entity handle given is invalid.")
            }
        };
    }
}

impl From<ComponentAllocError> for ECSError {
    fn from(v: ComponentAllocError) -> Self {
        Self::ComponentAllocError(v)
    }
}

impl Error for ECSError {}
