use std::{error::Error, fmt::Display};

/// Returned whenever a component allocation fails.
#[derive(Debug, PartialEq, Eq)]
pub struct ComponentAllocError();

impl Default for ComponentAllocError {
    fn default() -> Self {
        Self {}
    }
}

impl Display for ComponentAllocError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "Could not allocate memory for components!")
    }
}

impl Error for ComponentAllocError {}
